// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App Ingress configuration.
 */
@Immutable
public final class JavaComponentIngress implements JsonSerializable<JavaComponentIngress> {
    /*
     * Hostname of the Java Component endpoint
     */
    private String fqdn;

    /**
     * Creates an instance of JavaComponentIngress class.
     */
    public JavaComponentIngress() {
    }

    /**
     * Get the fqdn property: Hostname of the Java Component endpoint.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JavaComponentIngress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JavaComponentIngress if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the JavaComponentIngress.
     */
    public static JavaComponentIngress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JavaComponentIngress deserializedJavaComponentIngress = new JavaComponentIngress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fqdn".equals(fieldName)) {
                    deserializedJavaComponentIngress.fqdn = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJavaComponentIngress;
        });
    }
}
