// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the Java Component.
 */
public final class JavaComponentProvisioningState extends ExpandableStringEnum<JavaComponentProvisioningState> {
    /**
     * Static value Succeeded for JavaComponentProvisioningState.
     */
    public static final JavaComponentProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for JavaComponentProvisioningState.
     */
    public static final JavaComponentProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Canceled for JavaComponentProvisioningState.
     */
    public static final JavaComponentProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Deleting for JavaComponentProvisioningState.
     */
    public static final JavaComponentProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value InProgress for JavaComponentProvisioningState.
     */
    public static final JavaComponentProvisioningState IN_PROGRESS = fromString("InProgress");

    /**
     * Creates a new instance of JavaComponentProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public JavaComponentProvisioningState() {
    }

    /**
     * Creates or finds a JavaComponentProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding JavaComponentProvisioningState.
     */
    public static JavaComponentProvisioningState fromString(String name) {
        return fromString(name, JavaComponentProvisioningState.class);
    }

    /**
     * Gets known JavaComponentProvisioningState values.
     * 
     * @return known JavaComponentProvisioningState values.
     */
    public static Collection<JavaComponentProvisioningState> values() {
        return values(JavaComponentProvisioningState.class);
    }
}
