// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration to bind a Java Component to another Java Component.
 */
@Fluent
public final class JavaComponentServiceBind implements JsonSerializable<JavaComponentServiceBind> {
    /*
     * Name of the service bind
     */
    private String name;

    /*
     * Resource id of the target service
     */
    private String serviceId;

    /**
     * Creates an instance of JavaComponentServiceBind class.
     */
    public JavaComponentServiceBind() {
    }

    /**
     * Get the name property: Name of the service bind.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the service bind.
     * 
     * @param name the name value to set.
     * @return the JavaComponentServiceBind object itself.
     */
    public JavaComponentServiceBind withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the serviceId property: Resource id of the target service.
     * 
     * @return the serviceId value.
     */
    public String serviceId() {
        return this.serviceId;
    }

    /**
     * Set the serviceId property: Resource id of the target service.
     * 
     * @param serviceId the serviceId value to set.
     * @return the JavaComponentServiceBind object itself.
     */
    public JavaComponentServiceBind withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("serviceId", this.serviceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JavaComponentServiceBind from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JavaComponentServiceBind if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the JavaComponentServiceBind.
     */
    public static JavaComponentServiceBind fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JavaComponentServiceBind deserializedJavaComponentServiceBind = new JavaComponentServiceBind();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedJavaComponentServiceBind.name = reader.getString();
                } else if ("serviceId".equals(fieldName)) {
                    deserializedJavaComponentServiceBind.serviceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJavaComponentServiceBind;
        });
    }
}
