// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of the Java Component.
 */
public final class JavaComponentType extends ExpandableStringEnum<JavaComponentType> {
    /**
     * Static value SpringBootAdmin for JavaComponentType.
     */
    public static final JavaComponentType SPRING_BOOT_ADMIN = fromString("SpringBootAdmin");

    /**
     * Static value SpringCloudEureka for JavaComponentType.
     */
    public static final JavaComponentType SPRING_CLOUD_EUREKA = fromString("SpringCloudEureka");

    /**
     * Static value SpringCloudConfig for JavaComponentType.
     */
    public static final JavaComponentType SPRING_CLOUD_CONFIG = fromString("SpringCloudConfig");

    /**
     * Static value Nacos for JavaComponentType.
     */
    public static final JavaComponentType NACOS = fromString("Nacos");

    /**
     * Creates a new instance of JavaComponentType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public JavaComponentType() {
    }

    /**
     * Creates or finds a JavaComponentType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding JavaComponentType.
     */
    public static JavaComponentType fromString(String name) {
        return fromString(name, JavaComponentType.class);
    }

    /**
     * Gets known JavaComponentType values.
     * 
     * @return known JavaComponentType values.
     */
    public static Collection<JavaComponentType> values() {
        return values(JavaComponentType.class);
    }
}
