// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Trigger configuration of an event driven job.
 */
@Fluent
public final class JobConfigurationEventTriggerConfig implements JsonSerializable<JobConfigurationEventTriggerConfig> {
    /*
     * Minimum number of successful replica completions before overall job completion.
     */
    private Integer replicaCompletionCount;

    /*
     * Number of parallel replicas of a job that can run at a given time.
     */
    private Integer parallelism;

    /*
     * Scaling configurations for event driven jobs.
     */
    private JobScale scale;

    /**
     * Creates an instance of JobConfigurationEventTriggerConfig class.
     */
    public JobConfigurationEventTriggerConfig() {
    }

    /**
     * Get the replicaCompletionCount property: Minimum number of successful replica completions before overall job
     * completion.
     * 
     * @return the replicaCompletionCount value.
     */
    public Integer replicaCompletionCount() {
        return this.replicaCompletionCount;
    }

    /**
     * Set the replicaCompletionCount property: Minimum number of successful replica completions before overall job
     * completion.
     * 
     * @param replicaCompletionCount the replicaCompletionCount value to set.
     * @return the JobConfigurationEventTriggerConfig object itself.
     */
    public JobConfigurationEventTriggerConfig withReplicaCompletionCount(Integer replicaCompletionCount) {
        this.replicaCompletionCount = replicaCompletionCount;
        return this;
    }

    /**
     * Get the parallelism property: Number of parallel replicas of a job that can run at a given time.
     * 
     * @return the parallelism value.
     */
    public Integer parallelism() {
        return this.parallelism;
    }

    /**
     * Set the parallelism property: Number of parallel replicas of a job that can run at a given time.
     * 
     * @param parallelism the parallelism value to set.
     * @return the JobConfigurationEventTriggerConfig object itself.
     */
    public JobConfigurationEventTriggerConfig withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    /**
     * Get the scale property: Scaling configurations for event driven jobs.
     * 
     * @return the scale value.
     */
    public JobScale scale() {
        return this.scale;
    }

    /**
     * Set the scale property: Scaling configurations for event driven jobs.
     * 
     * @param scale the scale value to set.
     * @return the JobConfigurationEventTriggerConfig object itself.
     */
    public JobConfigurationEventTriggerConfig withScale(JobScale scale) {
        this.scale = scale;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scale() != null) {
            scale().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("replicaCompletionCount", this.replicaCompletionCount);
        jsonWriter.writeNumberField("parallelism", this.parallelism);
        jsonWriter.writeJsonField("scale", this.scale);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobConfigurationEventTriggerConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobConfigurationEventTriggerConfig if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobConfigurationEventTriggerConfig.
     */
    public static JobConfigurationEventTriggerConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobConfigurationEventTriggerConfig deserializedJobConfigurationEventTriggerConfig
                = new JobConfigurationEventTriggerConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("replicaCompletionCount".equals(fieldName)) {
                    deserializedJobConfigurationEventTriggerConfig.replicaCompletionCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("parallelism".equals(fieldName)) {
                    deserializedJobConfigurationEventTriggerConfig.parallelism = reader.getNullable(JsonReader::getInt);
                } else if ("scale".equals(fieldName)) {
                    deserializedJobConfigurationEventTriggerConfig.scale = JobScale.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobConfigurationEventTriggerConfig;
        });
    }
}
