// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be
 * set to 1 by default.
 */
@Fluent
public final class JobConfigurationManualTriggerConfig
    implements JsonSerializable<JobConfigurationManualTriggerConfig> {
    /*
     * Minimum number of successful replica completions before overall job completion.
     */
    private Integer replicaCompletionCount;

    /*
     * Number of parallel replicas of a job that can run at a given time.
     */
    private Integer parallelism;

    /**
     * Creates an instance of JobConfigurationManualTriggerConfig class.
     */
    public JobConfigurationManualTriggerConfig() {
    }

    /**
     * Get the replicaCompletionCount property: Minimum number of successful replica completions before overall job
     * completion.
     * 
     * @return the replicaCompletionCount value.
     */
    public Integer replicaCompletionCount() {
        return this.replicaCompletionCount;
    }

    /**
     * Set the replicaCompletionCount property: Minimum number of successful replica completions before overall job
     * completion.
     * 
     * @param replicaCompletionCount the replicaCompletionCount value to set.
     * @return the JobConfigurationManualTriggerConfig object itself.
     */
    public JobConfigurationManualTriggerConfig withReplicaCompletionCount(Integer replicaCompletionCount) {
        this.replicaCompletionCount = replicaCompletionCount;
        return this;
    }

    /**
     * Get the parallelism property: Number of parallel replicas of a job that can run at a given time.
     * 
     * @return the parallelism value.
     */
    public Integer parallelism() {
        return this.parallelism;
    }

    /**
     * Set the parallelism property: Number of parallel replicas of a job that can run at a given time.
     * 
     * @param parallelism the parallelism value to set.
     * @return the JobConfigurationManualTriggerConfig object itself.
     */
    public JobConfigurationManualTriggerConfig withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("replicaCompletionCount", this.replicaCompletionCount);
        jsonWriter.writeNumberField("parallelism", this.parallelism);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobConfigurationManualTriggerConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobConfigurationManualTriggerConfig if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobConfigurationManualTriggerConfig.
     */
    public static JobConfigurationManualTriggerConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobConfigurationManualTriggerConfig deserializedJobConfigurationManualTriggerConfig
                = new JobConfigurationManualTriggerConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("replicaCompletionCount".equals(fieldName)) {
                    deserializedJobConfigurationManualTriggerConfig.replicaCompletionCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("parallelism".equals(fieldName)) {
                    deserializedJobConfigurationManualTriggerConfig.parallelism
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobConfigurationManualTriggerConfig;
        });
    }
}
