// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be
 * set to 1 by default.
 */
@Fluent
public final class JobConfigurationScheduleTriggerConfig
    implements JsonSerializable<JobConfigurationScheduleTriggerConfig> {
    /*
     * Minimum number of successful replica completions before overall job completion.
     */
    private Integer replicaCompletionCount;

    /*
     * Cron formatted repeating schedule ("* * * * *") of a Cron Job.
     */
    private String cronExpression;

    /*
     * Number of parallel replicas of a job that can run at a given time.
     */
    private Integer parallelism;

    /**
     * Creates an instance of JobConfigurationScheduleTriggerConfig class.
     */
    public JobConfigurationScheduleTriggerConfig() {
    }

    /**
     * Get the replicaCompletionCount property: Minimum number of successful replica completions before overall job
     * completion.
     * 
     * @return the replicaCompletionCount value.
     */
    public Integer replicaCompletionCount() {
        return this.replicaCompletionCount;
    }

    /**
     * Set the replicaCompletionCount property: Minimum number of successful replica completions before overall job
     * completion.
     * 
     * @param replicaCompletionCount the replicaCompletionCount value to set.
     * @return the JobConfigurationScheduleTriggerConfig object itself.
     */
    public JobConfigurationScheduleTriggerConfig withReplicaCompletionCount(Integer replicaCompletionCount) {
        this.replicaCompletionCount = replicaCompletionCount;
        return this;
    }

    /**
     * Get the cronExpression property: Cron formatted repeating schedule ("* * * * *") of a Cron Job.
     * 
     * @return the cronExpression value.
     */
    public String cronExpression() {
        return this.cronExpression;
    }

    /**
     * Set the cronExpression property: Cron formatted repeating schedule ("* * * * *") of a Cron Job.
     * 
     * @param cronExpression the cronExpression value to set.
     * @return the JobConfigurationScheduleTriggerConfig object itself.
     */
    public JobConfigurationScheduleTriggerConfig withCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    /**
     * Get the parallelism property: Number of parallel replicas of a job that can run at a given time.
     * 
     * @return the parallelism value.
     */
    public Integer parallelism() {
        return this.parallelism;
    }

    /**
     * Set the parallelism property: Number of parallel replicas of a job that can run at a given time.
     * 
     * @param parallelism the parallelism value to set.
     * @return the JobConfigurationScheduleTriggerConfig object itself.
     */
    public JobConfigurationScheduleTriggerConfig withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (cronExpression() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property cronExpression in model JobConfigurationScheduleTriggerConfig"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(JobConfigurationScheduleTriggerConfig.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cronExpression", this.cronExpression);
        jsonWriter.writeNumberField("replicaCompletionCount", this.replicaCompletionCount);
        jsonWriter.writeNumberField("parallelism", this.parallelism);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobConfigurationScheduleTriggerConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobConfigurationScheduleTriggerConfig if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the JobConfigurationScheduleTriggerConfig.
     */
    public static JobConfigurationScheduleTriggerConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobConfigurationScheduleTriggerConfig deserializedJobConfigurationScheduleTriggerConfig
                = new JobConfigurationScheduleTriggerConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cronExpression".equals(fieldName)) {
                    deserializedJobConfigurationScheduleTriggerConfig.cronExpression = reader.getString();
                } else if ("replicaCompletionCount".equals(fieldName)) {
                    deserializedJobConfigurationScheduleTriggerConfig.replicaCompletionCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("parallelism".equals(fieldName)) {
                    deserializedJobConfigurationScheduleTriggerConfig.parallelism
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobConfigurationScheduleTriggerConfig;
        });
    }
}
