// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Current running State of the job.
 */
public final class JobExecutionRunningState extends ExpandableStringEnum<JobExecutionRunningState> {
    /**
     * Static value Running for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState RUNNING = fromString("Running");

    /**
     * Static value Processing for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState PROCESSING = fromString("Processing");

    /**
     * Static value Stopped for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState STOPPED = fromString("Stopped");

    /**
     * Static value Degraded for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState DEGRADED = fromString("Degraded");

    /**
     * Static value Failed for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState FAILED = fromString("Failed");

    /**
     * Static value Unknown for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState UNKNOWN = fromString("Unknown");

    /**
     * Static value Succeeded for JobExecutionRunningState.
     */
    public static final JobExecutionRunningState SUCCEEDED = fromString("Succeeded");

    /**
     * Creates a new instance of JobExecutionRunningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public JobExecutionRunningState() {
    }

    /**
     * Creates or finds a JobExecutionRunningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding JobExecutionRunningState.
     */
    public static JobExecutionRunningState fromString(String name) {
        return fromString(name, JobExecutionRunningState.class);
    }

    /**
     * Gets known JobExecutionRunningState values.
     * 
     * @return known JobExecutionRunningState values.
     */
    public static Collection<JobExecutionRunningState> values() {
        return values(JobExecutionRunningState.class);
    }
}
