// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Job's execution template, containing container configuration for a job's execution.
 */
@Fluent
public final class JobExecutionTemplate implements JsonSerializable<JobExecutionTemplate> {
    /*
     * List of container definitions for the Container Apps Job.
     */
    private List<JobExecutionContainer> containers;

    /*
     * List of specialized containers that run before job containers.
     */
    private List<JobExecutionContainer> initContainers;

    /**
     * Creates an instance of JobExecutionTemplate class.
     */
    public JobExecutionTemplate() {
    }

    /**
     * Get the containers property: List of container definitions for the Container Apps Job.
     * 
     * @return the containers value.
     */
    public List<JobExecutionContainer> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: List of container definitions for the Container Apps Job.
     * 
     * @param containers the containers value to set.
     * @return the JobExecutionTemplate object itself.
     */
    public JobExecutionTemplate withContainers(List<JobExecutionContainer> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the initContainers property: List of specialized containers that run before job containers.
     * 
     * @return the initContainers value.
     */
    public List<JobExecutionContainer> initContainers() {
        return this.initContainers;
    }

    /**
     * Set the initContainers property: List of specialized containers that run before job containers.
     * 
     * @param initContainers the initContainers value to set.
     * @return the JobExecutionTemplate object itself.
     */
    public JobExecutionTemplate withInitContainers(List<JobExecutionContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containers() != null) {
            containers().forEach(e -> e.validate());
        }
        if (initContainers() != null) {
            initContainers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("initContainers", this.initContainers,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobExecutionTemplate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobExecutionTemplate if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobExecutionTemplate.
     */
    public static JobExecutionTemplate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobExecutionTemplate deserializedJobExecutionTemplate = new JobExecutionTemplate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containers".equals(fieldName)) {
                    List<JobExecutionContainer> containers
                        = reader.readArray(reader1 -> JobExecutionContainer.fromJson(reader1));
                    deserializedJobExecutionTemplate.containers = containers;
                } else if ("initContainers".equals(fieldName)) {
                    List<JobExecutionContainer> initContainers
                        = reader.readArray(reader1 -> JobExecutionContainer.fromJson(reader1));
                    deserializedJobExecutionTemplate.initContainers = initContainers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobExecutionTemplate;
        });
    }
}
