// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the Container Apps Job.
 */
public final class JobProvisioningState extends ExpandableStringEnum<JobProvisioningState> {
    /**
     * Static value InProgress for JobProvisioningState.
     */
    public static final JobProvisioningState IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Succeeded for JobProvisioningState.
     */
    public static final JobProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for JobProvisioningState.
     */
    public static final JobProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Canceled for JobProvisioningState.
     */
    public static final JobProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Deleting for JobProvisioningState.
     */
    public static final JobProvisioningState DELETING = fromString("Deleting");

    /**
     * Creates a new instance of JobProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public JobProvisioningState() {
    }

    /**
     * Creates or finds a JobProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding JobProvisioningState.
     */
    public static JobProvisioningState fromString(String name) {
        return fromString(name, JobProvisioningState.class);
    }

    /**
     * Gets known JobProvisioningState values.
     * 
     * @return known JobProvisioningState values.
     */
    public static Collection<JobProvisioningState> values() {
        return values(JobProvisioningState.class);
    }
}
