// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Scaling rule.
 */
@Fluent
public final class JobScaleRule implements JsonSerializable<JobScaleRule> {
    /*
     * Scale Rule Name
     */
    private String name;

    /*
     * Type of the scale rule
     * eg: azure-servicebus, redis etc.
     */
    private String type;

    /*
     * Metadata properties to describe the scale rule.
     */
    private Object metadata;

    /*
     * Authentication secrets for the scale rule.
     */
    private List<ScaleRuleAuth> auth;

    /*
     * The resource ID of a user-assigned managed identity that is assigned to the job, or 'system' for system-assigned
     * identity.
     */
    private String identity;

    /**
     * Creates an instance of JobScaleRule class.
     */
    public JobScaleRule() {
    }

    /**
     * Get the name property: Scale Rule Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Scale Rule Name.
     * 
     * @param name the name value to set.
     * @return the JobScaleRule object itself.
     */
    public JobScaleRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Type of the scale rule
     * eg: azure-servicebus, redis etc.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the scale rule
     * eg: azure-servicebus, redis etc.
     * 
     * @param type the type value to set.
     * @return the JobScaleRule object itself.
     */
    public JobScaleRule withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the metadata property: Metadata properties to describe the scale rule.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata properties to describe the scale rule.
     * 
     * @param metadata the metadata value to set.
     * @return the JobScaleRule object itself.
     */
    public JobScaleRule withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the auth property: Authentication secrets for the scale rule.
     * 
     * @return the auth value.
     */
    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    /**
     * Set the auth property: Authentication secrets for the scale rule.
     * 
     * @param auth the auth value to set.
     * @return the JobScaleRule object itself.
     */
    public JobScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    /**
     * Get the identity property: The resource ID of a user-assigned managed identity that is assigned to the job, or
     * 'system' for system-assigned identity.
     * 
     * @return the identity value.
     */
    public String identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The resource ID of a user-assigned managed identity that is assigned to the job, or
     * 'system' for system-assigned identity.
     * 
     * @param identity the identity value to set.
     * @return the JobScaleRule object itself.
     */
    public JobScaleRule withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (auth() != null) {
            auth().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobScaleRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobScaleRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobScaleRule.
     */
    public static JobScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobScaleRule deserializedJobScaleRule = new JobScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedJobScaleRule.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedJobScaleRule.type = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    deserializedJobScaleRule.metadata = reader.readUntyped();
                } else if ("auth".equals(fieldName)) {
                    List<ScaleRuleAuth> auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    deserializedJobScaleRule.auth = auth;
                } else if ("identity".equals(fieldName)) {
                    deserializedJobScaleRule.identity = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobScaleRule;
        });
    }
}
