// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container Apps Job versioned application definition. Defines the desired state of an immutable revision. Any changes
 * to this section Will result in a new revision being created.
 */
@Fluent
public final class JobTemplate implements JsonSerializable<JobTemplate> {
    /*
     * List of specialized containers that run before app containers.
     */
    private List<InitContainer> initContainers;

    /*
     * List of container definitions for the Container App.
     */
    private List<Container> containers;

    /*
     * List of volume definitions for the Container App.
     */
    private List<Volume> volumes;

    /**
     * Creates an instance of JobTemplate class.
     */
    public JobTemplate() {
    }

    /**
     * Get the initContainers property: List of specialized containers that run before app containers.
     * 
     * @return the initContainers value.
     */
    public List<InitContainer> initContainers() {
        return this.initContainers;
    }

    /**
     * Set the initContainers property: List of specialized containers that run before app containers.
     * 
     * @param initContainers the initContainers value to set.
     * @return the JobTemplate object itself.
     */
    public JobTemplate withInitContainers(List<InitContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    /**
     * Get the containers property: List of container definitions for the Container App.
     * 
     * @return the containers value.
     */
    public List<Container> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: List of container definitions for the Container App.
     * 
     * @param containers the containers value to set.
     * @return the JobTemplate object itself.
     */
    public JobTemplate withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the volumes property: List of volume definitions for the Container App.
     * 
     * @return the volumes value.
     */
    public List<Volume> volumes() {
        return this.volumes;
    }

    /**
     * Set the volumes property: List of volume definitions for the Container App.
     * 
     * @param volumes the volumes value to set.
     * @return the JobTemplate object itself.
     */
    public JobTemplate withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (initContainers() != null) {
            initContainers().forEach(e -> e.validate());
        }
        if (containers() != null) {
            containers().forEach(e -> e.validate());
        }
        if (volumes() != null) {
            volumes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("initContainers", this.initContainers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("volumes", this.volumes, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobTemplate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobTemplate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the JobTemplate.
     */
    public static JobTemplate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobTemplate deserializedJobTemplate = new JobTemplate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("initContainers".equals(fieldName)) {
                    List<InitContainer> initContainers = reader.readArray(reader1 -> InitContainer.fromJson(reader1));
                    deserializedJobTemplate.initContainers = initContainers;
                } else if ("containers".equals(fieldName)) {
                    List<Container> containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    deserializedJobTemplate.containers = containers;
                } else if ("volumes".equals(fieldName)) {
                    List<Volume> volumes = reader.readArray(reader1 -> Volume.fromJson(reader1));
                    deserializedJobTemplate.volumes = volumes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobTemplate;
        });
    }
}
