// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration settings of the checks that should be made while validating the JWT Claims.
 */
@Fluent
public final class JwtClaimChecks implements JsonSerializable<JwtClaimChecks> {
    /*
     * The list of the allowed groups.
     */
    private List<String> allowedGroups;

    /*
     * The list of the allowed client applications.
     */
    private List<String> allowedClientApplications;

    /**
     * Creates an instance of JwtClaimChecks class.
     */
    public JwtClaimChecks() {
    }

    /**
     * Get the allowedGroups property: The list of the allowed groups.
     * 
     * @return the allowedGroups value.
     */
    public List<String> allowedGroups() {
        return this.allowedGroups;
    }

    /**
     * Set the allowedGroups property: The list of the allowed groups.
     * 
     * @param allowedGroups the allowedGroups value to set.
     * @return the JwtClaimChecks object itself.
     */
    public JwtClaimChecks withAllowedGroups(List<String> allowedGroups) {
        this.allowedGroups = allowedGroups;
        return this;
    }

    /**
     * Get the allowedClientApplications property: The list of the allowed client applications.
     * 
     * @return the allowedClientApplications value.
     */
    public List<String> allowedClientApplications() {
        return this.allowedClientApplications;
    }

    /**
     * Set the allowedClientApplications property: The list of the allowed client applications.
     * 
     * @param allowedClientApplications the allowedClientApplications value to set.
     * @return the JwtClaimChecks object itself.
     */
    public JwtClaimChecks withAllowedClientApplications(List<String> allowedClientApplications) {
        this.allowedClientApplications = allowedClientApplications;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedGroups", this.allowedGroups,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedClientApplications", this.allowedClientApplications,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JwtClaimChecks from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JwtClaimChecks if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the JwtClaimChecks.
     */
    public static JwtClaimChecks fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JwtClaimChecks deserializedJwtClaimChecks = new JwtClaimChecks();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedGroups".equals(fieldName)) {
                    List<String> allowedGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedJwtClaimChecks.allowedGroups = allowedGroups;
                } else if ("allowedClientApplications".equals(fieldName)) {
                    List<String> allowedClientApplications = reader.readArray(reader1 -> reader1.getString());
                    deserializedJwtClaimChecks.allowedClientApplications = allowedClientApplications;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJwtClaimChecks;
        });
    }
}
