// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The specified logger's log level.
 */
public final class Level extends ExpandableStringEnum<Level> {
    /**
     * Static value off for Level.
     */
    public static final Level OFF = fromString("off");

    /**
     * Static value error for Level.
     */
    public static final Level ERROR = fromString("error");

    /**
     * Static value info for Level.
     */
    public static final Level INFO = fromString("info");

    /**
     * Static value debug for Level.
     */
    public static final Level DEBUG = fromString("debug");

    /**
     * Static value trace for Level.
     */
    public static final Level TRACE = fromString("trace");

    /**
     * Static value warn for Level.
     */
    public static final Level WARN = fromString("warn");

    /**
     * Creates a new instance of Level value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Level() {
    }

    /**
     * Creates or finds a Level from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Level.
     */
    public static Level fromString(String name) {
        return fromString(name, Level.class);
    }

    /**
     * Gets known Level values.
     * 
     * @return known Level values.
     */
    public static Collection<Level> values() {
        return values(Level.class);
    }
}
