// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Logger settings for java workloads.
 */
@Fluent
public final class LoggerSetting implements JsonSerializable<LoggerSetting> {
    /*
     * Logger name.
     */
    private String logger;

    /*
     * The specified logger's log level.
     */
    private Level level;

    /**
     * Creates an instance of LoggerSetting class.
     */
    public LoggerSetting() {
    }

    /**
     * Get the logger property: Logger name.
     * 
     * @return the logger value.
     */
    public String logger() {
        return this.logger;
    }

    /**
     * Set the logger property: Logger name.
     * 
     * @param logger the logger value to set.
     * @return the LoggerSetting object itself.
     */
    public LoggerSetting withLogger(String logger) {
        this.logger = logger;
        return this;
    }

    /**
     * Get the level property: The specified logger's log level.
     * 
     * @return the level value.
     */
    public Level level() {
        return this.level;
    }

    /**
     * Set the level property: The specified logger's log level.
     * 
     * @param level the level value to set.
     * @return the LoggerSetting object itself.
     */
    public LoggerSetting withLevel(Level level) {
        this.level = level;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logger() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property logger in model LoggerSetting"));
        }
        if (level() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property level in model LoggerSetting"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LoggerSetting.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logger", this.logger);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoggerSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoggerSetting if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LoggerSetting.
     */
    public static LoggerSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoggerSetting deserializedLoggerSetting = new LoggerSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("logger".equals(fieldName)) {
                    deserializedLoggerSetting.logger = reader.getString();
                } else if ("level".equals(fieldName)) {
                    deserializedLoggerSetting.level = Level.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoggerSetting;
        });
    }
}
