// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of LogicApps.
 */
public interface LogicApps {
    /**
     * Gets a logic app extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource along with {@link Response}.
     */
    Response<LogicApp> getWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        Context context);

    /**
     * Gets a logic app extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource.
     */
    LogicApp get(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * Deletes a Logic App extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        Context context);

    /**
     * Deletes a Logic App extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * List the workflows for a logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of workflow information elements as paginated response with {@link PagedIterable}.
     */
    PagedIterable<WorkflowEnvelope> listWorkflows(String resourceGroupName, String containerAppName,
        String logicAppName);

    /**
     * List the workflows for a logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of workflow information elements as paginated response with {@link PagedIterable}.
     */
    PagedIterable<WorkflowEnvelope> listWorkflows(String resourceGroupName, String containerAppName,
        String logicAppName, Context context);

    /**
     * Get workflow information by its name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param workflowName Workflow name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workflow information by its name along with {@link Response}.
     */
    Response<WorkflowEnvelope> getWorkflowWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, String workflowName, Context context);

    /**
     * Get workflow information by its name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param workflowName Workflow name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workflow information by its name.
     */
    WorkflowEnvelope getWorkflow(String resourceGroupName, String containerAppName, String logicAppName,
        String workflowName);

    /**
     * Creates or updates the artifacts for the logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param workflowArtifacts Application settings and files of the workflow.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deployWorkflowArtifactsWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, WorkflowArtifacts workflowArtifacts, Context context);

    /**
     * Creates or updates the artifacts for the logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deployWorkflowArtifacts(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * Gets logic app's connections.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return logic app's connections along with {@link Response}.
     */
    Response<WorkflowEnvelope> listWorkflowsConnectionsWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, Context context);

    /**
     * Gets logic app's connections.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return logic app's connections.
     */
    WorkflowEnvelope listWorkflowsConnections(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * Proxies a the API call to the logic app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the LogicApp App, the extension resource.
     * @param xMsLogicAppsProxyPath The proxy path for the API call.
     * @param xMsLogicAppsProxyMethod The proxy method for the API call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    Response<Object> invokeWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod, Context context);

    /**
     * Proxies a the API call to the logic app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the LogicApp App, the extension resource.
     * @param xMsLogicAppsProxyPath The proxy path for the API call.
     * @param xMsLogicAppsProxyMethod The proxy method for the API call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    Object invoke(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath,
        LogicAppsProxyMethod xMsLogicAppsProxyMethod);

    /**
     * Gets a logic app extension resource.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource along with {@link Response}.
     */
    LogicApp getById(String id);

    /**
     * Gets a logic app extension resource.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource along with {@link Response}.
     */
    Response<LogicApp> getByIdWithResponse(String id, Context context);

    /**
     * Deletes a Logic App extension resource.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes a Logic App extension resource.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new LogicApp resource.
     * 
     * @param name resource name.
     * @return the first stage of the new LogicApp definition.
     */
    LogicApp.DefinitionStages.Blank define(String name);
}
