// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Certificate resource specific properties.
 */
@Fluent
public final class ManagedCertificateProperties implements JsonSerializable<ManagedCertificateProperties> {
    /*
     * Provisioning state of the certificate.
     */
    private CertificateProvisioningState provisioningState;

    /*
     * Subject name of the certificate.
     */
    private String subjectName;

    /*
     * Any error occurred during the certificate provision.
     */
    private String error;

    /*
     * Selected type of domain control validation for managed certificates.
     */
    private ManagedCertificateDomainControlValidation domainControlValidation;

    /*
     * A TXT token used for DNS TXT domain control validation when issuing this type of managed certificates.
     */
    private String validationToken;

    /**
     * Creates an instance of ManagedCertificateProperties class.
     */
    public ManagedCertificateProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the certificate.
     * 
     * @return the provisioningState value.
     */
    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the subjectName property: Subject name of the certificate.
     * 
     * @return the subjectName value.
     */
    public String subjectName() {
        return this.subjectName;
    }

    /**
     * Set the subjectName property: Subject name of the certificate.
     * 
     * @param subjectName the subjectName value to set.
     * @return the ManagedCertificateProperties object itself.
     */
    public ManagedCertificateProperties withSubjectName(String subjectName) {
        this.subjectName = subjectName;
        return this;
    }

    /**
     * Get the error property: Any error occurred during the certificate provision.
     * 
     * @return the error value.
     */
    public String error() {
        return this.error;
    }

    /**
     * Get the domainControlValidation property: Selected type of domain control validation for managed certificates.
     * 
     * @return the domainControlValidation value.
     */
    public ManagedCertificateDomainControlValidation domainControlValidation() {
        return this.domainControlValidation;
    }

    /**
     * Set the domainControlValidation property: Selected type of domain control validation for managed certificates.
     * 
     * @param domainControlValidation the domainControlValidation value to set.
     * @return the ManagedCertificateProperties object itself.
     */
    public ManagedCertificateProperties
        withDomainControlValidation(ManagedCertificateDomainControlValidation domainControlValidation) {
        this.domainControlValidation = domainControlValidation;
        return this;
    }

    /**
     * Get the validationToken property: A TXT token used for DNS TXT domain control validation when issuing this type
     * of managed certificates.
     * 
     * @return the validationToken value.
     */
    public String validationToken() {
        return this.validationToken;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subjectName", this.subjectName);
        jsonWriter.writeStringField("domainControlValidation",
            this.domainControlValidation == null ? null : this.domainControlValidation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedCertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedCertificateProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedCertificateProperties.
     */
    public static ManagedCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedCertificateProperties deserializedManagedCertificateProperties = new ManagedCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedCertificateProperties.provisioningState
                        = CertificateProvisioningState.fromString(reader.getString());
                } else if ("subjectName".equals(fieldName)) {
                    deserializedManagedCertificateProperties.subjectName = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedManagedCertificateProperties.error = reader.getString();
                } else if ("domainControlValidation".equals(fieldName)) {
                    deserializedManagedCertificateProperties.domainControlValidation
                        = ManagedCertificateDomainControlValidation.fromString(reader.getString());
                } else if ("validationToken".equals(fieldName)) {
                    deserializedManagedCertificateProperties.validationToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedCertificateProperties;
        });
    }
}
