// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Peer authentication settings for the Managed Environment.
 */
@Fluent
public final class ManagedEnvironmentPropertiesPeerAuthentication
    implements JsonSerializable<ManagedEnvironmentPropertiesPeerAuthentication> {
    /*
     * Mutual TLS authentication settings for the Managed Environment
     */
    private Mtls mtls;

    /**
     * Creates an instance of ManagedEnvironmentPropertiesPeerAuthentication class.
     */
    public ManagedEnvironmentPropertiesPeerAuthentication() {
    }

    /**
     * Get the mtls property: Mutual TLS authentication settings for the Managed Environment.
     * 
     * @return the mtls value.
     */
    public Mtls mtls() {
        return this.mtls;
    }

    /**
     * Set the mtls property: Mutual TLS authentication settings for the Managed Environment.
     * 
     * @param mtls the mtls value to set.
     * @return the ManagedEnvironmentPropertiesPeerAuthentication object itself.
     */
    public ManagedEnvironmentPropertiesPeerAuthentication withMtls(Mtls mtls) {
        this.mtls = mtls;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mtls() != null) {
            mtls().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("mtls", this.mtls);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedEnvironmentPropertiesPeerAuthentication from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedEnvironmentPropertiesPeerAuthentication if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedEnvironmentPropertiesPeerAuthentication.
     */
    public static ManagedEnvironmentPropertiesPeerAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedEnvironmentPropertiesPeerAuthentication deserializedManagedEnvironmentPropertiesPeerAuthentication
                = new ManagedEnvironmentPropertiesPeerAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mtls".equals(fieldName)) {
                    deserializedManagedEnvironmentPropertiesPeerAuthentication.mtls = Mtls.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedEnvironmentPropertiesPeerAuthentication;
        });
    }
}
