// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Peer traffic encryption settings for the Managed Environment.
 */
@Fluent
public final class ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption
    implements JsonSerializable<ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption> {
    /*
     * Boolean indicating whether the peer traffic encryption is enabled
     */
    private Boolean enabled;

    /**
     * Creates an instance of ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption class.
     */
    public ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption() {
    }

    /**
     * Get the enabled property: Boolean indicating whether the peer traffic encryption is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Boolean indicating whether the peer traffic encryption is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption object itself.
     */
    public ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption.
     */
    public static ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption deserializedManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption
                = new ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption;
        });
    }
}
