// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Storage properties.
 */
@Fluent
public final class ManagedEnvironmentStorageProperties
    implements JsonSerializable<ManagedEnvironmentStorageProperties> {
    /*
     * Azure file properties
     */
    private AzureFileProperties azureFile;

    /*
     * NFS Azure file properties
     */
    private NfsAzureFileProperties nfsAzureFile;

    /**
     * Creates an instance of ManagedEnvironmentStorageProperties class.
     */
    public ManagedEnvironmentStorageProperties() {
    }

    /**
     * Get the azureFile property: Azure file properties.
     * 
     * @return the azureFile value.
     */
    public AzureFileProperties azureFile() {
        return this.azureFile;
    }

    /**
     * Set the azureFile property: Azure file properties.
     * 
     * @param azureFile the azureFile value to set.
     * @return the ManagedEnvironmentStorageProperties object itself.
     */
    public ManagedEnvironmentStorageProperties withAzureFile(AzureFileProperties azureFile) {
        this.azureFile = azureFile;
        return this;
    }

    /**
     * Get the nfsAzureFile property: NFS Azure file properties.
     * 
     * @return the nfsAzureFile value.
     */
    public NfsAzureFileProperties nfsAzureFile() {
        return this.nfsAzureFile;
    }

    /**
     * Set the nfsAzureFile property: NFS Azure file properties.
     * 
     * @param nfsAzureFile the nfsAzureFile value to set.
     * @return the ManagedEnvironmentStorageProperties object itself.
     */
    public ManagedEnvironmentStorageProperties withNfsAzureFile(NfsAzureFileProperties nfsAzureFile) {
        this.nfsAzureFile = nfsAzureFile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureFile() != null) {
            azureFile().validate();
        }
        if (nfsAzureFile() != null) {
            nfsAzureFile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureFile", this.azureFile);
        jsonWriter.writeJsonField("nfsAzureFile", this.nfsAzureFile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedEnvironmentStorageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedEnvironmentStorageProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedEnvironmentStorageProperties.
     */
    public static ManagedEnvironmentStorageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedEnvironmentStorageProperties deserializedManagedEnvironmentStorageProperties
                = new ManagedEnvironmentStorageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureFile".equals(fieldName)) {
                    deserializedManagedEnvironmentStorageProperties.azureFile = AzureFileProperties.fromJson(reader);
                } else if ("nfsAzureFile".equals(fieldName)) {
                    deserializedManagedEnvironmentStorageProperties.nfsAzureFile
                        = NfsAzureFileProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedEnvironmentStorageProperties;
        });
    }
}
