// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration properties for mutual TLS authentication.
 */
@Fluent
public final class Mtls implements JsonSerializable<Mtls> {
    /*
     * Boolean indicating whether the mutual TLS authentication is enabled
     */
    private Boolean enabled;

    /**
     * Creates an instance of Mtls class.
     */
    public Mtls() {
    }

    /**
     * Get the enabled property: Boolean indicating whether the mutual TLS authentication is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Boolean indicating whether the mutual TLS authentication is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the Mtls object itself.
     */
    public Mtls withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Mtls from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Mtls if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Mtls.
     */
    public static Mtls fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Mtls deserializedMtls = new Mtls();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedMtls.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMtls;
        });
    }
}
