// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * NFS Azure File Properties.
 */
@Fluent
public final class NfsAzureFileProperties implements JsonSerializable<NfsAzureFileProperties> {
    /*
     * Server for NFS azure file.
     */
    private String server;

    /*
     * Access mode for storage
     */
    private AccessMode accessMode;

    /*
     * NFS Azure file share name.
     */
    private String shareName;

    /**
     * Creates an instance of NfsAzureFileProperties class.
     */
    public NfsAzureFileProperties() {
    }

    /**
     * Get the server property: Server for NFS azure file.
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: Server for NFS azure file.
     * 
     * @param server the server value to set.
     * @return the NfsAzureFileProperties object itself.
     */
    public NfsAzureFileProperties withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the accessMode property: Access mode for storage.
     * 
     * @return the accessMode value.
     */
    public AccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access mode for storage.
     * 
     * @param accessMode the accessMode value to set.
     * @return the NfsAzureFileProperties object itself.
     */
    public NfsAzureFileProperties withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Get the shareName property: NFS Azure file share name.
     * 
     * @return the shareName value.
     */
    public String shareName() {
        return this.shareName;
    }

    /**
     * Set the shareName property: NFS Azure file share name.
     * 
     * @param shareName the shareName value to set.
     * @return the NfsAzureFileProperties object itself.
     */
    public NfsAzureFileProperties withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        jsonWriter.writeStringField("shareName", this.shareName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NfsAzureFileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NfsAzureFileProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NfsAzureFileProperties.
     */
    public static NfsAzureFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NfsAzureFileProperties deserializedNfsAzureFileProperties = new NfsAzureFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("server".equals(fieldName)) {
                    deserializedNfsAzureFileProperties.server = reader.getString();
                } else if ("accessMode".equals(fieldName)) {
                    deserializedNfsAzureFileProperties.accessMode = AccessMode.fromString(reader.getString());
                } else if ("shareName".equals(fieldName)) {
                    deserializedNfsAzureFileProperties.shareName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNfsAzureFileProperties;
        });
    }
}
