// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication client credentials of the custom Open ID Connect provider.
 */
@Fluent
public final class OpenIdConnectClientCredential implements JsonSerializable<OpenIdConnectClientCredential> {
    /*
     * The method that should be used to authenticate the user.
     */
    private ClientCredentialMethod method;

    /*
     * The app setting that contains the client secret for the custom Open ID Connect provider.
     */
    private String clientSecretSettingName;

    /**
     * Creates an instance of OpenIdConnectClientCredential class.
     */
    public OpenIdConnectClientCredential() {
    }

    /**
     * Get the method property: The method that should be used to authenticate the user.
     * 
     * @return the method value.
     */
    public ClientCredentialMethod method() {
        return this.method;
    }

    /**
     * Set the method property: The method that should be used to authenticate the user.
     * 
     * @param method the method value to set.
     * @return the OpenIdConnectClientCredential object itself.
     */
    public OpenIdConnectClientCredential withMethod(ClientCredentialMethod method) {
        this.method = method;
        return this;
    }

    /**
     * Get the clientSecretSettingName property: The app setting that contains the client secret for the custom Open ID
     * Connect provider.
     * 
     * @return the clientSecretSettingName value.
     */
    public String clientSecretSettingName() {
        return this.clientSecretSettingName;
    }

    /**
     * Set the clientSecretSettingName property: The app setting that contains the client secret for the custom Open ID
     * Connect provider.
     * 
     * @param clientSecretSettingName the clientSecretSettingName value to set.
     * @return the OpenIdConnectClientCredential object itself.
     */
    public OpenIdConnectClientCredential withClientSecretSettingName(String clientSecretSettingName) {
        this.clientSecretSettingName = clientSecretSettingName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeStringField("clientSecretSettingName", this.clientSecretSettingName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenIdConnectClientCredential from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenIdConnectClientCredential if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenIdConnectClientCredential.
     */
    public static OpenIdConnectClientCredential fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenIdConnectClientCredential deserializedOpenIdConnectClientCredential
                = new OpenIdConnectClientCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("method".equals(fieldName)) {
                    deserializedOpenIdConnectClientCredential.method
                        = ClientCredentialMethod.fromString(reader.getString());
                } else if ("clientSecretSettingName".equals(fieldName)) {
                    deserializedOpenIdConnectClientCredential.clientSecretSettingName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenIdConnectClientCredential;
        });
    }
}
