// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the endpoints used for the custom Open ID Connect provider.
 */
@Fluent
public final class OpenIdConnectConfig implements JsonSerializable<OpenIdConnectConfig> {
    /*
     * The endpoint to be used to make an authorization request.
     */
    private String authorizationEndpoint;

    /*
     * The endpoint to be used to request a token.
     */
    private String tokenEndpoint;

    /*
     * The endpoint that issues the token.
     */
    private String issuer;

    /*
     * The endpoint that provides the keys necessary to validate the token.
     */
    private String certificationUri;

    /*
     * The endpoint that contains all the configuration endpoints for the provider.
     */
    private String wellKnownOpenIdConfiguration;

    /**
     * Creates an instance of OpenIdConnectConfig class.
     */
    public OpenIdConnectConfig() {
    }

    /**
     * Get the authorizationEndpoint property: The endpoint to be used to make an authorization request.
     * 
     * @return the authorizationEndpoint value.
     */
    public String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    /**
     * Set the authorizationEndpoint property: The endpoint to be used to make an authorization request.
     * 
     * @param authorizationEndpoint the authorizationEndpoint value to set.
     * @return the OpenIdConnectConfig object itself.
     */
    public OpenIdConnectConfig withAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    /**
     * Get the tokenEndpoint property: The endpoint to be used to request a token.
     * 
     * @return the tokenEndpoint value.
     */
    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    /**
     * Set the tokenEndpoint property: The endpoint to be used to request a token.
     * 
     * @param tokenEndpoint the tokenEndpoint value to set.
     * @return the OpenIdConnectConfig object itself.
     */
    public OpenIdConnectConfig withTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    /**
     * Get the issuer property: The endpoint that issues the token.
     * 
     * @return the issuer value.
     */
    public String issuer() {
        return this.issuer;
    }

    /**
     * Set the issuer property: The endpoint that issues the token.
     * 
     * @param issuer the issuer value to set.
     * @return the OpenIdConnectConfig object itself.
     */
    public OpenIdConnectConfig withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    /**
     * Get the certificationUri property: The endpoint that provides the keys necessary to validate the token.
     * 
     * @return the certificationUri value.
     */
    public String certificationUri() {
        return this.certificationUri;
    }

    /**
     * Set the certificationUri property: The endpoint that provides the keys necessary to validate the token.
     * 
     * @param certificationUri the certificationUri value to set.
     * @return the OpenIdConnectConfig object itself.
     */
    public OpenIdConnectConfig withCertificationUri(String certificationUri) {
        this.certificationUri = certificationUri;
        return this;
    }

    /**
     * Get the wellKnownOpenIdConfiguration property: The endpoint that contains all the configuration endpoints for the
     * provider.
     * 
     * @return the wellKnownOpenIdConfiguration value.
     */
    public String wellKnownOpenIdConfiguration() {
        return this.wellKnownOpenIdConfiguration;
    }

    /**
     * Set the wellKnownOpenIdConfiguration property: The endpoint that contains all the configuration endpoints for the
     * provider.
     * 
     * @param wellKnownOpenIdConfiguration the wellKnownOpenIdConfiguration value to set.
     * @return the OpenIdConnectConfig object itself.
     */
    public OpenIdConnectConfig withWellKnownOpenIdConfiguration(String wellKnownOpenIdConfiguration) {
        this.wellKnownOpenIdConfiguration = wellKnownOpenIdConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authorizationEndpoint", this.authorizationEndpoint);
        jsonWriter.writeStringField("tokenEndpoint", this.tokenEndpoint);
        jsonWriter.writeStringField("issuer", this.issuer);
        jsonWriter.writeStringField("certificationUri", this.certificationUri);
        jsonWriter.writeStringField("wellKnownOpenIdConfiguration", this.wellKnownOpenIdConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenIdConnectConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenIdConnectConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenIdConnectConfig.
     */
    public static OpenIdConnectConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenIdConnectConfig deserializedOpenIdConnectConfig = new OpenIdConnectConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("authorizationEndpoint".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.authorizationEndpoint = reader.getString();
                } else if ("tokenEndpoint".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.tokenEndpoint = reader.getString();
                } else if ("issuer".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.issuer = reader.getString();
                } else if ("certificationUri".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.certificationUri = reader.getString();
                } else if ("wellKnownOpenIdConfiguration".equals(fieldName)) {
                    deserializedOpenIdConnectConfig.wellKnownOpenIdConfiguration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenIdConnectConfig;
        });
    }
}
