// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration of Open Telemetry.
 */
@Fluent
public final class OpenTelemetryConfiguration implements JsonSerializable<OpenTelemetryConfiguration> {
    /*
     * Open telemetry destinations configuration
     */
    private DestinationsConfiguration destinationsConfiguration;

    /*
     * Open telemetry trace configuration
     */
    private TracesConfiguration tracesConfiguration;

    /*
     * Open telemetry logs configuration
     */
    private LogsConfiguration logsConfiguration;

    /*
     * Open telemetry metrics configuration
     */
    private MetricsConfiguration metricsConfiguration;

    /**
     * Creates an instance of OpenTelemetryConfiguration class.
     */
    public OpenTelemetryConfiguration() {
    }

    /**
     * Get the destinationsConfiguration property: Open telemetry destinations configuration.
     * 
     * @return the destinationsConfiguration value.
     */
    public DestinationsConfiguration destinationsConfiguration() {
        return this.destinationsConfiguration;
    }

    /**
     * Set the destinationsConfiguration property: Open telemetry destinations configuration.
     * 
     * @param destinationsConfiguration the destinationsConfiguration value to set.
     * @return the OpenTelemetryConfiguration object itself.
     */
    public OpenTelemetryConfiguration
        withDestinationsConfiguration(DestinationsConfiguration destinationsConfiguration) {
        this.destinationsConfiguration = destinationsConfiguration;
        return this;
    }

    /**
     * Get the tracesConfiguration property: Open telemetry trace configuration.
     * 
     * @return the tracesConfiguration value.
     */
    public TracesConfiguration tracesConfiguration() {
        return this.tracesConfiguration;
    }

    /**
     * Set the tracesConfiguration property: Open telemetry trace configuration.
     * 
     * @param tracesConfiguration the tracesConfiguration value to set.
     * @return the OpenTelemetryConfiguration object itself.
     */
    public OpenTelemetryConfiguration withTracesConfiguration(TracesConfiguration tracesConfiguration) {
        this.tracesConfiguration = tracesConfiguration;
        return this;
    }

    /**
     * Get the logsConfiguration property: Open telemetry logs configuration.
     * 
     * @return the logsConfiguration value.
     */
    public LogsConfiguration logsConfiguration() {
        return this.logsConfiguration;
    }

    /**
     * Set the logsConfiguration property: Open telemetry logs configuration.
     * 
     * @param logsConfiguration the logsConfiguration value to set.
     * @return the OpenTelemetryConfiguration object itself.
     */
    public OpenTelemetryConfiguration withLogsConfiguration(LogsConfiguration logsConfiguration) {
        this.logsConfiguration = logsConfiguration;
        return this;
    }

    /**
     * Get the metricsConfiguration property: Open telemetry metrics configuration.
     * 
     * @return the metricsConfiguration value.
     */
    public MetricsConfiguration metricsConfiguration() {
        return this.metricsConfiguration;
    }

    /**
     * Set the metricsConfiguration property: Open telemetry metrics configuration.
     * 
     * @param metricsConfiguration the metricsConfiguration value to set.
     * @return the OpenTelemetryConfiguration object itself.
     */
    public OpenTelemetryConfiguration withMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.metricsConfiguration = metricsConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destinationsConfiguration() != null) {
            destinationsConfiguration().validate();
        }
        if (tracesConfiguration() != null) {
            tracesConfiguration().validate();
        }
        if (logsConfiguration() != null) {
            logsConfiguration().validate();
        }
        if (metricsConfiguration() != null) {
            metricsConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destinationsConfiguration", this.destinationsConfiguration);
        jsonWriter.writeJsonField("tracesConfiguration", this.tracesConfiguration);
        jsonWriter.writeJsonField("logsConfiguration", this.logsConfiguration);
        jsonWriter.writeJsonField("metricsConfiguration", this.metricsConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenTelemetryConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenTelemetryConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenTelemetryConfiguration.
     */
    public static OpenTelemetryConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenTelemetryConfiguration deserializedOpenTelemetryConfiguration = new OpenTelemetryConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destinationsConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.destinationsConfiguration
                        = DestinationsConfiguration.fromJson(reader);
                } else if ("tracesConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.tracesConfiguration = TracesConfiguration.fromJson(reader);
                } else if ("logsConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.logsConfiguration = LogsConfiguration.fromJson(reader);
                } else if ("metricsConfiguration".equals(fieldName)) {
                    deserializedOpenTelemetryConfiguration.metricsConfiguration = MetricsConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenTelemetryConfiguration;
        });
    }
}
