// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Configuration of otlp.
 */
@Fluent
public final class OtlpConfiguration implements JsonSerializable<OtlpConfiguration> {
    /*
     * The name of otlp configuration
     */
    private String name;

    /*
     * The endpoint of otlp configuration
     */
    private String endpoint;

    /*
     * Boolean indicating if otlp configuration is insecure
     */
    private Boolean insecure;

    /*
     * Headers of otlp configurations
     */
    private List<Header> headers;

    /**
     * Creates an instance of OtlpConfiguration class.
     */
    public OtlpConfiguration() {
    }

    /**
     * Get the name property: The name of otlp configuration.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of otlp configuration.
     * 
     * @param name the name value to set.
     * @return the OtlpConfiguration object itself.
     */
    public OtlpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the endpoint property: The endpoint of otlp configuration.
     * 
     * @return the endpoint value.
     */
    public String endpoint() {
        return this.endpoint;
    }

    /**
     * Set the endpoint property: The endpoint of otlp configuration.
     * 
     * @param endpoint the endpoint value to set.
     * @return the OtlpConfiguration object itself.
     */
    public OtlpConfiguration withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /**
     * Get the insecure property: Boolean indicating if otlp configuration is insecure.
     * 
     * @return the insecure value.
     */
    public Boolean insecure() {
        return this.insecure;
    }

    /**
     * Set the insecure property: Boolean indicating if otlp configuration is insecure.
     * 
     * @param insecure the insecure value to set.
     * @return the OtlpConfiguration object itself.
     */
    public OtlpConfiguration withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    /**
     * Get the headers property: Headers of otlp configurations.
     * 
     * @return the headers value.
     */
    public List<Header> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: Headers of otlp configurations.
     * 
     * @param headers the headers value to set.
     * @return the OtlpConfiguration object itself.
     */
    public OtlpConfiguration withHeaders(List<Header> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (headers() != null) {
            headers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeBooleanField("insecure", this.insecure);
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OtlpConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OtlpConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OtlpConfiguration.
     */
    public static OtlpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OtlpConfiguration deserializedOtlpConfiguration = new OtlpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOtlpConfiguration.name = reader.getString();
                } else if ("endpoint".equals(fieldName)) {
                    deserializedOtlpConfiguration.endpoint = reader.getString();
                } else if ("insecure".equals(fieldName)) {
                    deserializedOtlpConfiguration.insecure = reader.getNullable(JsonReader::getBoolean);
                } else if ("headers".equals(fieldName)) {
                    List<Header> headers = reader.readArray(reader1 -> Header.fromJson(reader1));
                    deserializedOtlpConfiguration.headers = headers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOtlpConfiguration;
        });
    }
}
