// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The status of the patch once it has been provisioned.
 */
public final class PatchApplyStatus extends ExpandableStringEnum<PatchApplyStatus> {
    /**
     * Static value NotStarted for PatchApplyStatus.
     */
    public static final PatchApplyStatus NOT_STARTED = fromString("NotStarted");

    /**
     * Static value RebaseInProgress for PatchApplyStatus.
     */
    public static final PatchApplyStatus REBASE_IN_PROGRESS = fromString("RebaseInProgress");

    /**
     * Static value CreatingRevision for PatchApplyStatus.
     */
    public static final PatchApplyStatus CREATING_REVISION = fromString("CreatingRevision");

    /**
     * Static value Succeeded for PatchApplyStatus.
     */
    public static final PatchApplyStatus SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceled for PatchApplyStatus.
     */
    public static final PatchApplyStatus CANCELED = fromString("Canceled");

    /**
     * Static value RebaseFailed for PatchApplyStatus.
     */
    public static final PatchApplyStatus REBASE_FAILED = fromString("RebaseFailed");

    /**
     * Static value RevisionCreationFailed for PatchApplyStatus.
     */
    public static final PatchApplyStatus REVISION_CREATION_FAILED = fromString("RevisionCreationFailed");

    /**
     * Static value ImagePushPullFailed for PatchApplyStatus.
     */
    public static final PatchApplyStatus IMAGE_PUSH_PULL_FAILED = fromString("ImagePushPullFailed");

    /**
     * Static value ManuallySkipped for PatchApplyStatus.
     */
    public static final PatchApplyStatus MANUALLY_SKIPPED = fromString("ManuallySkipped");

    /**
     * Creates a new instance of PatchApplyStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PatchApplyStatus() {
    }

    /**
     * Creates or finds a PatchApplyStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PatchApplyStatus.
     */
    public static PatchApplyStatus fromString(String name) {
        return fromString(name, PatchApplyStatus.class);
    }

    /**
     * Gets known PatchApplyStatus values.
     * 
     * @return known PatchApplyStatus values.
     */
    public static Collection<PatchApplyStatus> values() {
        return values(PatchApplyStatus.class);
    }
}
