// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsPatchResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Container App patch collection.
 */
@Fluent
public final class PatchCollection implements JsonSerializable<PatchCollection> {
    /*
     * Collection of patch resources.
     */
    private List<ContainerAppsPatchResourceInner> value;

    /*
     * the link to the next page of items
     */
    private String nextLink;

    /**
     * Creates an instance of PatchCollection class.
     */
    public PatchCollection() {
    }

    /**
     * Get the value property: Collection of patch resources.
     * 
     * @return the value value.
     */
    public List<ContainerAppsPatchResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of patch resources.
     * 
     * @param value the value value to set.
     * @return the PatchCollection object itself.
     */
    public PatchCollection withValue(List<ContainerAppsPatchResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: the link to the next page of items.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: the link to the next page of items.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PatchCollection object itself.
     */
    public PatchCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model PatchCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PatchCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatchCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatchCollection if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PatchCollection.
     */
    public static PatchCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PatchCollection deserializedPatchCollection = new PatchCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ContainerAppsPatchResourceInner> value
                        = reader.readArray(reader1 -> ContainerAppsPatchResourceInner.fromJson(reader1));
                    deserializedPatchCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPatchCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPatchCollection;
        });
    }
}
