// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The detailed info of patch operation performing when applying a patch.
 */
@Immutable
public final class PatchDetails implements JsonSerializable<PatchDetails> {
    /*
     * The name of the target container for the patch.
     */
    private String targetContainerName;

    /*
     * The name of the target image for the patch.
     */
    private String targetImage;

    /*
     * The UTC timestamp that describes the latest detection was done.
     */
    private OffsetDateTime lastDetectionTime;

    /*
     * The status of the patch detection.
     */
    private DetectionStatus detectionStatus;

    /*
     * The name of the new image created by the patch.
     */
    private String newImageName;

    /*
     * New layer update details in the target image.
     */
    private PatchDetailsNewLayer newLayer;

    /*
     * The old layer details in the target image.
     */
    private PatchDetailsOldLayer oldLayer;

    /*
     * The type for the patch.
     */
    private PatchType patchType;

    /**
     * Creates an instance of PatchDetails class.
     */
    public PatchDetails() {
    }

    /**
     * Get the targetContainerName property: The name of the target container for the patch.
     * 
     * @return the targetContainerName value.
     */
    public String targetContainerName() {
        return this.targetContainerName;
    }

    /**
     * Get the targetImage property: The name of the target image for the patch.
     * 
     * @return the targetImage value.
     */
    public String targetImage() {
        return this.targetImage;
    }

    /**
     * Get the lastDetectionTime property: The UTC timestamp that describes the latest detection was done.
     * 
     * @return the lastDetectionTime value.
     */
    public OffsetDateTime lastDetectionTime() {
        return this.lastDetectionTime;
    }

    /**
     * Get the detectionStatus property: The status of the patch detection.
     * 
     * @return the detectionStatus value.
     */
    public DetectionStatus detectionStatus() {
        return this.detectionStatus;
    }

    /**
     * Get the newImageName property: The name of the new image created by the patch.
     * 
     * @return the newImageName value.
     */
    public String newImageName() {
        return this.newImageName;
    }

    /**
     * Get the newLayer property: New layer update details in the target image.
     * 
     * @return the newLayer value.
     */
    public PatchDetailsNewLayer newLayer() {
        return this.newLayer;
    }

    /**
     * Get the oldLayer property: The old layer details in the target image.
     * 
     * @return the oldLayer value.
     */
    public PatchDetailsOldLayer oldLayer() {
        return this.oldLayer;
    }

    /**
     * Get the patchType property: The type for the patch.
     * 
     * @return the patchType value.
     */
    public PatchType patchType() {
        return this.patchType;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (newLayer() != null) {
            newLayer().validate();
        }
        if (oldLayer() != null) {
            oldLayer().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatchDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatchDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PatchDetails.
     */
    public static PatchDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PatchDetails deserializedPatchDetails = new PatchDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetContainerName".equals(fieldName)) {
                    deserializedPatchDetails.targetContainerName = reader.getString();
                } else if ("targetImage".equals(fieldName)) {
                    deserializedPatchDetails.targetImage = reader.getString();
                } else if ("lastDetectionTime".equals(fieldName)) {
                    deserializedPatchDetails.lastDetectionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("detectionStatus".equals(fieldName)) {
                    deserializedPatchDetails.detectionStatus = DetectionStatus.fromString(reader.getString());
                } else if ("newImageName".equals(fieldName)) {
                    deserializedPatchDetails.newImageName = reader.getString();
                } else if ("newLayer".equals(fieldName)) {
                    deserializedPatchDetails.newLayer = PatchDetailsNewLayer.fromJson(reader);
                } else if ("oldLayer".equals(fieldName)) {
                    deserializedPatchDetails.oldLayer = PatchDetailsOldLayer.fromJson(reader);
                } else if ("patchType".equals(fieldName)) {
                    deserializedPatchDetails.patchType = PatchType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPatchDetails;
        });
    }
}
