// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * New layer update details in the target image.
 */
@Fluent
public final class PatchDetailsNewLayer implements JsonSerializable<PatchDetailsNewLayer> {
    /*
     * The details of the new layer for the target image.
     */
    private String name;

    /*
     * The framework and its version in the new run image for the target image.
     */
    private String frameworkAndVersion;

    /*
     * The OS name and its version in the new run image for the target image.
     */
    private String osAndVersion;

    /**
     * Creates an instance of PatchDetailsNewLayer class.
     */
    public PatchDetailsNewLayer() {
    }

    /**
     * Get the name property: The details of the new layer for the target image.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The details of the new layer for the target image.
     * 
     * @param name the name value to set.
     * @return the PatchDetailsNewLayer object itself.
     */
    public PatchDetailsNewLayer withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the frameworkAndVersion property: The framework and its version in the new run image for the target image.
     * 
     * @return the frameworkAndVersion value.
     */
    public String frameworkAndVersion() {
        return this.frameworkAndVersion;
    }

    /**
     * Set the frameworkAndVersion property: The framework and its version in the new run image for the target image.
     * 
     * @param frameworkAndVersion the frameworkAndVersion value to set.
     * @return the PatchDetailsNewLayer object itself.
     */
    public PatchDetailsNewLayer withFrameworkAndVersion(String frameworkAndVersion) {
        this.frameworkAndVersion = frameworkAndVersion;
        return this;
    }

    /**
     * Get the osAndVersion property: The OS name and its version in the new run image for the target image.
     * 
     * @return the osAndVersion value.
     */
    public String osAndVersion() {
        return this.osAndVersion;
    }

    /**
     * Set the osAndVersion property: The OS name and its version in the new run image for the target image.
     * 
     * @param osAndVersion the osAndVersion value to set.
     * @return the PatchDetailsNewLayer object itself.
     */
    public PatchDetailsNewLayer withOsAndVersion(String osAndVersion) {
        this.osAndVersion = osAndVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("frameworkAndVersion", this.frameworkAndVersion);
        jsonWriter.writeStringField("osAndVersion", this.osAndVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatchDetailsNewLayer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatchDetailsNewLayer if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PatchDetailsNewLayer.
     */
    public static PatchDetailsNewLayer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PatchDetailsNewLayer deserializedPatchDetailsNewLayer = new PatchDetailsNewLayer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPatchDetailsNewLayer.name = reader.getString();
                } else if ("frameworkAndVersion".equals(fieldName)) {
                    deserializedPatchDetailsNewLayer.frameworkAndVersion = reader.getString();
                } else if ("osAndVersion".equals(fieldName)) {
                    deserializedPatchDetailsNewLayer.osAndVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPatchDetailsNewLayer;
        });
    }
}
