// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The old layer details in the target image.
 */
@Fluent
public final class PatchDetailsOldLayer implements JsonSerializable<PatchDetailsOldLayer> {
    /*
     * The details of the old layer for the target image.
     */
    private String name;

    /*
     * The framework and its version in the old run image for the target image.
     */
    private String frameworkAndVersion;

    /*
     * The OS name and its version in the old run image for the target image.
     */
    private String osAndVersion;

    /**
     * Creates an instance of PatchDetailsOldLayer class.
     */
    public PatchDetailsOldLayer() {
    }

    /**
     * Get the name property: The details of the old layer for the target image.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The details of the old layer for the target image.
     * 
     * @param name the name value to set.
     * @return the PatchDetailsOldLayer object itself.
     */
    public PatchDetailsOldLayer withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the frameworkAndVersion property: The framework and its version in the old run image for the target image.
     * 
     * @return the frameworkAndVersion value.
     */
    public String frameworkAndVersion() {
        return this.frameworkAndVersion;
    }

    /**
     * Set the frameworkAndVersion property: The framework and its version in the old run image for the target image.
     * 
     * @param frameworkAndVersion the frameworkAndVersion value to set.
     * @return the PatchDetailsOldLayer object itself.
     */
    public PatchDetailsOldLayer withFrameworkAndVersion(String frameworkAndVersion) {
        this.frameworkAndVersion = frameworkAndVersion;
        return this;
    }

    /**
     * Get the osAndVersion property: The OS name and its version in the old run image for the target image.
     * 
     * @return the osAndVersion value.
     */
    public String osAndVersion() {
        return this.osAndVersion;
    }

    /**
     * Set the osAndVersion property: The OS name and its version in the old run image for the target image.
     * 
     * @param osAndVersion the osAndVersion value to set.
     * @return the PatchDetailsOldLayer object itself.
     */
    public PatchDetailsOldLayer withOsAndVersion(String osAndVersion) {
        this.osAndVersion = osAndVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("frameworkAndVersion", this.frameworkAndVersion);
        jsonWriter.writeStringField("osAndVersion", this.osAndVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatchDetailsOldLayer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatchDetailsOldLayer if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PatchDetailsOldLayer.
     */
    public static PatchDetailsOldLayer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PatchDetailsOldLayer deserializedPatchDetailsOldLayer = new PatchDetailsOldLayer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPatchDetailsOldLayer.name = reader.getString();
                } else if ("frameworkAndVersion".equals(fieldName)) {
                    deserializedPatchDetailsOldLayer.frameworkAndVersion = reader.getString();
                } else if ("osAndVersion".equals(fieldName)) {
                    deserializedPatchDetailsOldLayer.osAndVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPatchDetailsOldLayer;
        });
    }
}
