// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration for patcher to skip a patch or not.
 */
@Fluent
public final class PatchSkipConfig implements JsonSerializable<PatchSkipConfig> {
    /*
     * The flag to indicate whether to skip the patch or not.
     */
    private Boolean skip;

    /**
     * Creates an instance of PatchSkipConfig class.
     */
    public PatchSkipConfig() {
    }

    /**
     * Get the skip property: The flag to indicate whether to skip the patch or not.
     * 
     * @return the skip value.
     */
    public Boolean skip() {
        return this.skip;
    }

    /**
     * Set the skip property: The flag to indicate whether to skip the patch or not.
     * 
     * @param skip the skip value to set.
     * @return the PatchSkipConfig object itself.
     */
    public PatchSkipConfig withSkip(Boolean skip) {
        this.skip = skip;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("skip", this.skip);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatchSkipConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatchSkipConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PatchSkipConfig.
     */
    public static PatchSkipConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PatchSkipConfig deserializedPatchSkipConfig = new PatchSkipConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("skip".equals(fieldName)) {
                    deserializedPatchSkipConfig.skip = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPatchSkipConfig;
        });
    }
}
