// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type for the patch.
 */
public final class PatchType extends ExpandableStringEnum<PatchType> {
    /**
     * Static value FrameworkSecurity for PatchType.
     */
    public static final PatchType FRAMEWORK_SECURITY = fromString("FrameworkSecurity");

    /**
     * Static value OSSecurity for PatchType.
     */
    public static final PatchType OSSECURITY = fromString("OSSecurity");

    /**
     * Static value FrameworkAndOSSecurity for PatchType.
     */
    public static final PatchType FRAMEWORK_AND_OSSECURITY = fromString("FrameworkAndOSSecurity");

    /**
     * Static value Other for PatchType.
     */
    public static final PatchType OTHER = fromString("Other");

    /**
     * Creates a new instance of PatchType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PatchType() {
    }

    /**
     * Creates or finds a PatchType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PatchType.
     */
    public static PatchType fromString(String name) {
        return fromString(name, PatchType.class);
    }

    /**
     * Gets known PatchType values.
     * 
     * @return known PatchType values.
     */
    public static Collection<PatchType> values() {
        return values(PatchType.class);
    }
}
