// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Patching mode for the container app. Null or default in this field will be interpreted as Automatic by RP. Automatic
 * mode will automatically apply available patches. Manual mode will require the user to manually apply patches.
 * Disabled mode will stop patch detection and auto patching.
 */
public final class PatchingMode extends ExpandableStringEnum<PatchingMode> {
    /**
     * Static value Automatic for PatchingMode.
     */
    public static final PatchingMode AUTOMATIC = fromString("Automatic");

    /**
     * Static value Manual for PatchingMode.
     */
    public static final PatchingMode MANUAL = fromString("Manual");

    /**
     * Static value Disabled for PatchingMode.
     */
    public static final PatchingMode DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of PatchingMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PatchingMode() {
    }

    /**
     * Creates or finds a PatchingMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PatchingMode.
     */
    public static PatchingMode fromString(String name) {
        return fromString(name, PatchingMode.class);
    }

    /**
     * Gets known PatchingMode values.
     * 
     * @return known PatchingMode values.
     */
    public static Collection<PatchingMode> values() {
        return values(PatchingMode.class);
    }
}
