// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The pool management type of the session pool.
 */
public final class PoolManagementType extends ExpandableStringEnum<PoolManagementType> {
    /**
     * Static value Manual for PoolManagementType.
     */
    public static final PoolManagementType MANUAL = fromString("Manual");

    /**
     * Static value Dynamic for PoolManagementType.
     */
    public static final PoolManagementType DYNAMIC = fromString("Dynamic");

    /**
     * Creates a new instance of PoolManagementType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PoolManagementType() {
    }

    /**
     * Creates or finds a PoolManagementType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PoolManagementType.
     */
    public static PoolManagementType fromString(String name) {
        return fromString(name, PoolManagementType.class);
    }

    /**
     * Gets known PoolManagementType values.
     * 
     * @return known PoolManagementType values.
     */
    public static Collection<PoolManagementType> values() {
        return values(PoolManagementType.class);
    }
}
