// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Model representing a pre-build step.
 */
@Fluent
public final class PreBuildStep implements JsonSerializable<PreBuildStep> {
    /*
     * Description of the pre-build step.
     */
    private String description;

    /*
     * List of custom commands to run.
     */
    private List<String> scripts;

    /*
     * Http get request to send before the build.
     */
    private HttpGet httpGet;

    /**
     * Creates an instance of PreBuildStep class.
     */
    public PreBuildStep() {
    }

    /**
     * Get the description property: Description of the pre-build step.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the pre-build step.
     * 
     * @param description the description value to set.
     * @return the PreBuildStep object itself.
     */
    public PreBuildStep withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the scripts property: List of custom commands to run.
     * 
     * @return the scripts value.
     */
    public List<String> scripts() {
        return this.scripts;
    }

    /**
     * Set the scripts property: List of custom commands to run.
     * 
     * @param scripts the scripts value to set.
     * @return the PreBuildStep object itself.
     */
    public PreBuildStep withScripts(List<String> scripts) {
        this.scripts = scripts;
        return this;
    }

    /**
     * Get the httpGet property: Http get request to send before the build.
     * 
     * @return the httpGet value.
     */
    public HttpGet httpGet() {
        return this.httpGet;
    }

    /**
     * Set the httpGet property: Http get request to send before the build.
     * 
     * @param httpGet the httpGet value to set.
     * @return the PreBuildStep object itself.
     */
    public PreBuildStep withHttpGet(HttpGet httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (httpGet() != null) {
            httpGet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("scripts", this.scripts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("httpGet", this.httpGet);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PreBuildStep from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PreBuildStep if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PreBuildStep.
     */
    public static PreBuildStep fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PreBuildStep deserializedPreBuildStep = new PreBuildStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedPreBuildStep.description = reader.getString();
                } else if ("scripts".equals(fieldName)) {
                    List<String> scripts = reader.readArray(reader1 -> reader1.getString());
                    deserializedPreBuildStep.scripts = scripts;
                } else if ("httpGet".equals(fieldName)) {
                    deserializedPreBuildStep.httpGet = HttpGet.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPreBuildStep;
        });
    }
}
