// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container App container Azure Queue based scaling rule.
 */
@Fluent
public final class QueueScaleRule implements JsonSerializable<QueueScaleRule> {
    /*
     * Storage account name. required if using managed identity to authenticate
     */
    private String accountName;

    /*
     * Queue name.
     */
    private String queueName;

    /*
     * Queue length.
     */
    private Integer queueLength;

    /*
     * Authentication secrets for the queue scale rule.
     */
    private List<ScaleRuleAuth> auth;

    /*
     * The resource ID of a user-assigned managed identity that is assigned to the Container App, or 'system' for
     * system-assigned identity.
     */
    private String identity;

    /**
     * Creates an instance of QueueScaleRule class.
     */
    public QueueScaleRule() {
    }

    /**
     * Get the accountName property: Storage account name. required if using managed identity to authenticate.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: Storage account name. required if using managed identity to authenticate.
     * 
     * @param accountName the accountName value to set.
     * @return the QueueScaleRule object itself.
     */
    public QueueScaleRule withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the queueName property: Queue name.
     * 
     * @return the queueName value.
     */
    public String queueName() {
        return this.queueName;
    }

    /**
     * Set the queueName property: Queue name.
     * 
     * @param queueName the queueName value to set.
     * @return the QueueScaleRule object itself.
     */
    public QueueScaleRule withQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    /**
     * Get the queueLength property: Queue length.
     * 
     * @return the queueLength value.
     */
    public Integer queueLength() {
        return this.queueLength;
    }

    /**
     * Set the queueLength property: Queue length.
     * 
     * @param queueLength the queueLength value to set.
     * @return the QueueScaleRule object itself.
     */
    public QueueScaleRule withQueueLength(Integer queueLength) {
        this.queueLength = queueLength;
        return this;
    }

    /**
     * Get the auth property: Authentication secrets for the queue scale rule.
     * 
     * @return the auth value.
     */
    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    /**
     * Set the auth property: Authentication secrets for the queue scale rule.
     * 
     * @param auth the auth value to set.
     * @return the QueueScaleRule object itself.
     */
    public QueueScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    /**
     * Get the identity property: The resource ID of a user-assigned managed identity that is assigned to the Container
     * App, or 'system' for system-assigned identity.
     * 
     * @return the identity value.
     */
    public String identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The resource ID of a user-assigned managed identity that is assigned to the Container
     * App, or 'system' for system-assigned identity.
     * 
     * @param identity the identity value to set.
     * @return the QueueScaleRule object itself.
     */
    public QueueScaleRule withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (auth() != null) {
            auth().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("queueName", this.queueName);
        jsonWriter.writeNumberField("queueLength", this.queueLength);
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueueScaleRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueueScaleRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueueScaleRule.
     */
    public static QueueScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueueScaleRule deserializedQueueScaleRule = new QueueScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountName".equals(fieldName)) {
                    deserializedQueueScaleRule.accountName = reader.getString();
                } else if ("queueName".equals(fieldName)) {
                    deserializedQueueScaleRule.queueName = reader.getString();
                } else if ("queueLength".equals(fieldName)) {
                    deserializedQueueScaleRule.queueLength = reader.getNullable(JsonReader::getInt);
                } else if ("auth".equals(fieldName)) {
                    List<ScaleRuleAuth> auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    deserializedQueueScaleRule.auth = auth;
                } else if ("identity".equals(fieldName)) {
                    deserializedQueueScaleRule.identity = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueueScaleRule;
        });
    }
}
