// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container Apps Job execution replica status.
 */
@Fluent
public final class ReplicaExecutionStatus implements JsonSerializable<ReplicaExecutionStatus> {
    /*
     * Replica Name.
     */
    private String name;

    /*
     * Containers in the execution replica
     */
    private List<ContainerExecutionStatus> containers;

    /**
     * Creates an instance of ReplicaExecutionStatus class.
     */
    public ReplicaExecutionStatus() {
    }

    /**
     * Get the name property: Replica Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Replica Name.
     * 
     * @param name the name value to set.
     * @return the ReplicaExecutionStatus object itself.
     */
    public ReplicaExecutionStatus withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the containers property: Containers in the execution replica.
     * 
     * @return the containers value.
     */
    public List<ContainerExecutionStatus> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: Containers in the execution replica.
     * 
     * @param containers the containers value to set.
     * @return the ReplicaExecutionStatus object itself.
     */
    public ReplicaExecutionStatus withContainers(List<ContainerExecutionStatus> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containers() != null) {
            containers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReplicaExecutionStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReplicaExecutionStatus if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReplicaExecutionStatus.
     */
    public static ReplicaExecutionStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReplicaExecutionStatus deserializedReplicaExecutionStatus = new ReplicaExecutionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedReplicaExecutionStatus.name = reader.getString();
                } else if ("containers".equals(fieldName)) {
                    List<ContainerExecutionStatus> containers
                        = reader.readArray(reader1 -> ContainerExecutionStatus.fromJson(reader1));
                    deserializedReplicaExecutionStatus.containers = containers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReplicaExecutionStatus;
        });
    }
}
