// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.RevisionInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of Revision.
 */
public interface Revision {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the createdTime property: Timestamp describing when the revision was created
     * by controller.
     * 
     * @return the createdTime value.
     */
    OffsetDateTime createdTime();

    /**
     * Gets the lastActiveTime property: Timestamp describing when the revision was last active. Only meaningful when
     * revision is inactive.
     * 
     * @return the lastActiveTime value.
     */
    OffsetDateTime lastActiveTime();

    /**
     * Gets the fqdn property: Fully qualified domain name of the revision.
     * 
     * @return the fqdn value.
     */
    String fqdn();

    /**
     * Gets the template property: Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time.
     * 
     * @return the template value.
     */
    Template template();

    /**
     * Gets the active property: Boolean describing if the Revision is Active.
     * 
     * @return the active value.
     */
    Boolean active();

    /**
     * Gets the replicas property: Number of pods currently running for this revision.
     * 
     * @return the replicas value.
     */
    Integer replicas();

    /**
     * Gets the trafficWeight property: Traffic weight assigned to this revision.
     * 
     * @return the trafficWeight value.
     */
    Integer trafficWeight();

    /**
     * Gets the provisioningError property: Optional Field - Platform Error Message.
     * 
     * @return the provisioningError value.
     */
    String provisioningError();

    /**
     * Gets the healthState property: Current health State of the revision.
     * 
     * @return the healthState value.
     */
    RevisionHealthState healthState();

    /**
     * Gets the provisioningState property: Current provisioning State of the revision.
     * 
     * @return the provisioningState value.
     */
    RevisionProvisioningState provisioningState();

    /**
     * Gets the runningState property: Current running state of the revision.
     * 
     * @return the runningState value.
     */
    RevisionRunningState runningState();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.RevisionInner object.
     * 
     * @return the inner object.
     */
    RevisionInner innerModel();
}
