// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Current running state of the revision.
 */
public final class RevisionRunningState extends ExpandableStringEnum<RevisionRunningState> {
    /**
     * Static value Running for RevisionRunningState.
     */
    public static final RevisionRunningState RUNNING = fromString("Running");

    /**
     * Static value Processing for RevisionRunningState.
     */
    public static final RevisionRunningState PROCESSING = fromString("Processing");

    /**
     * Static value Stopped for RevisionRunningState.
     */
    public static final RevisionRunningState STOPPED = fromString("Stopped");

    /**
     * Static value Degraded for RevisionRunningState.
     */
    public static final RevisionRunningState DEGRADED = fromString("Degraded");

    /**
     * Static value Failed for RevisionRunningState.
     */
    public static final RevisionRunningState FAILED = fromString("Failed");

    /**
     * Static value Unknown for RevisionRunningState.
     */
    public static final RevisionRunningState UNKNOWN = fromString("Unknown");

    /**
     * Creates a new instance of RevisionRunningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RevisionRunningState() {
    }

    /**
     * Creates or finds a RevisionRunningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RevisionRunningState.
     */
    public static RevisionRunningState fromString(String name) {
        return fromString(name, RevisionRunningState.class);
    }

    /**
     * Gets known RevisionRunningState values.
     * 
     * @return known RevisionRunningState values.
     */
    public static Collection<RevisionRunningState> values() {
        return values(RevisionRunningState.class);
    }
}
