// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Java app configuration.
 */
@Fluent
public final class RuntimeJava implements JsonSerializable<RuntimeJava> {
    /*
     * Enable jmx core metrics for the java app
     */
    private Boolean enableMetrics;

    /*
     * Diagnostic capabilities achieved by java agent
     */
    private RuntimeJavaAgent javaAgent;

    /**
     * Creates an instance of RuntimeJava class.
     */
    public RuntimeJava() {
    }

    /**
     * Get the enableMetrics property: Enable jmx core metrics for the java app.
     * 
     * @return the enableMetrics value.
     */
    public Boolean enableMetrics() {
        return this.enableMetrics;
    }

    /**
     * Set the enableMetrics property: Enable jmx core metrics for the java app.
     * 
     * @param enableMetrics the enableMetrics value to set.
     * @return the RuntimeJava object itself.
     */
    public RuntimeJava withEnableMetrics(Boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return this;
    }

    /**
     * Get the javaAgent property: Diagnostic capabilities achieved by java agent.
     * 
     * @return the javaAgent value.
     */
    public RuntimeJavaAgent javaAgent() {
        return this.javaAgent;
    }

    /**
     * Set the javaAgent property: Diagnostic capabilities achieved by java agent.
     * 
     * @param javaAgent the javaAgent value to set.
     * @return the RuntimeJava object itself.
     */
    public RuntimeJava withJavaAgent(RuntimeJavaAgent javaAgent) {
        this.javaAgent = javaAgent;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (javaAgent() != null) {
            javaAgent().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableMetrics", this.enableMetrics);
        jsonWriter.writeJsonField("javaAgent", this.javaAgent);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuntimeJava from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuntimeJava if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RuntimeJava.
     */
    public static RuntimeJava fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuntimeJava deserializedRuntimeJava = new RuntimeJava();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enableMetrics".equals(fieldName)) {
                    deserializedRuntimeJava.enableMetrics = reader.getNullable(JsonReader::getBoolean);
                } else if ("javaAgent".equals(fieldName)) {
                    deserializedRuntimeJava.javaAgent = RuntimeJavaAgent.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuntimeJava;
        });
    }
}
