// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Capabilities on the java logging scenario.
 */
@Fluent
public final class RuntimeJavaAgentLogging implements JsonSerializable<RuntimeJavaAgentLogging> {
    /*
     * Settings of the logger for the java app.
     */
    private List<LoggerSetting> loggerSettings;

    /**
     * Creates an instance of RuntimeJavaAgentLogging class.
     */
    public RuntimeJavaAgentLogging() {
    }

    /**
     * Get the loggerSettings property: Settings of the logger for the java app.
     * 
     * @return the loggerSettings value.
     */
    public List<LoggerSetting> loggerSettings() {
        return this.loggerSettings;
    }

    /**
     * Set the loggerSettings property: Settings of the logger for the java app.
     * 
     * @param loggerSettings the loggerSettings value to set.
     * @return the RuntimeJavaAgentLogging object itself.
     */
    public RuntimeJavaAgentLogging withLoggerSettings(List<LoggerSetting> loggerSettings) {
        this.loggerSettings = loggerSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loggerSettings() != null) {
            loggerSettings().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("loggerSettings", this.loggerSettings,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuntimeJavaAgentLogging from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuntimeJavaAgentLogging if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RuntimeJavaAgentLogging.
     */
    public static RuntimeJavaAgentLogging fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuntimeJavaAgentLogging deserializedRuntimeJavaAgentLogging = new RuntimeJavaAgentLogging();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loggerSettings".equals(fieldName)) {
                    List<LoggerSetting> loggerSettings = reader.readArray(reader1 -> LoggerSetting.fromJson(reader1));
                    deserializedRuntimeJavaAgentLogging.loggerSettings = loggerSettings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuntimeJavaAgentLogging;
        });
    }
}
