// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App container scaling rule.
 */
@Fluent
public final class ScaleRule implements JsonSerializable<ScaleRule> {
    /*
     * Scale Rule Name
     */
    private String name;

    /*
     * Azure Queue based scaling.
     */
    private QueueScaleRule azureQueue;

    /*
     * Custom scale rule.
     */
    private CustomScaleRule custom;

    /*
     * HTTP requests based scaling.
     */
    private HttpScaleRule http;

    /*
     * Tcp requests based scaling.
     */
    private TcpScaleRule tcp;

    /**
     * Creates an instance of ScaleRule class.
     */
    public ScaleRule() {
    }

    /**
     * Get the name property: Scale Rule Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Scale Rule Name.
     * 
     * @param name the name value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the azureQueue property: Azure Queue based scaling.
     * 
     * @return the azureQueue value.
     */
    public QueueScaleRule azureQueue() {
        return this.azureQueue;
    }

    /**
     * Set the azureQueue property: Azure Queue based scaling.
     * 
     * @param azureQueue the azureQueue value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withAzureQueue(QueueScaleRule azureQueue) {
        this.azureQueue = azureQueue;
        return this;
    }

    /**
     * Get the custom property: Custom scale rule.
     * 
     * @return the custom value.
     */
    public CustomScaleRule custom() {
        return this.custom;
    }

    /**
     * Set the custom property: Custom scale rule.
     * 
     * @param custom the custom value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withCustom(CustomScaleRule custom) {
        this.custom = custom;
        return this;
    }

    /**
     * Get the http property: HTTP requests based scaling.
     * 
     * @return the http value.
     */
    public HttpScaleRule http() {
        return this.http;
    }

    /**
     * Set the http property: HTTP requests based scaling.
     * 
     * @param http the http value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withHttp(HttpScaleRule http) {
        this.http = http;
        return this;
    }

    /**
     * Get the tcp property: Tcp requests based scaling.
     * 
     * @return the tcp value.
     */
    public TcpScaleRule tcp() {
        return this.tcp;
    }

    /**
     * Set the tcp property: Tcp requests based scaling.
     * 
     * @param tcp the tcp value to set.
     * @return the ScaleRule object itself.
     */
    public ScaleRule withTcp(TcpScaleRule tcp) {
        this.tcp = tcp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureQueue() != null) {
            azureQueue().validate();
        }
        if (custom() != null) {
            custom().validate();
        }
        if (http() != null) {
            http().validate();
        }
        if (tcp() != null) {
            tcp().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("azureQueue", this.azureQueue);
        jsonWriter.writeJsonField("custom", this.custom);
        jsonWriter.writeJsonField("http", this.http);
        jsonWriter.writeJsonField("tcp", this.tcp);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScaleRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScaleRule if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ScaleRule.
     */
    public static ScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScaleRule deserializedScaleRule = new ScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedScaleRule.name = reader.getString();
                } else if ("azureQueue".equals(fieldName)) {
                    deserializedScaleRule.azureQueue = QueueScaleRule.fromJson(reader);
                } else if ("custom".equals(fieldName)) {
                    deserializedScaleRule.custom = CustomScaleRule.fromJson(reader);
                } else if ("http".equals(fieldName)) {
                    deserializedScaleRule.http = HttpScaleRule.fromJson(reader);
                } else if ("tcp".equals(fieldName)) {
                    deserializedScaleRule.tcp = TcpScaleRule.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScaleRule;
        });
    }
}
