// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Auth Secrets for Scale Rule.
 */
@Fluent
public final class ScaleRuleAuth implements JsonSerializable<ScaleRuleAuth> {
    /*
     * Name of the secret from which to pull the auth params.
     */
    private String secretRef;

    /*
     * Trigger Parameter that uses the secret
     */
    private String triggerParameter;

    /**
     * Creates an instance of ScaleRuleAuth class.
     */
    public ScaleRuleAuth() {
    }

    /**
     * Get the secretRef property: Name of the secret from which to pull the auth params.
     * 
     * @return the secretRef value.
     */
    public String secretRef() {
        return this.secretRef;
    }

    /**
     * Set the secretRef property: Name of the secret from which to pull the auth params.
     * 
     * @param secretRef the secretRef value to set.
     * @return the ScaleRuleAuth object itself.
     */
    public ScaleRuleAuth withSecretRef(String secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    /**
     * Get the triggerParameter property: Trigger Parameter that uses the secret.
     * 
     * @return the triggerParameter value.
     */
    public String triggerParameter() {
        return this.triggerParameter;
    }

    /**
     * Set the triggerParameter property: Trigger Parameter that uses the secret.
     * 
     * @param triggerParameter the triggerParameter value to set.
     * @return the ScaleRuleAuth object itself.
     */
    public ScaleRuleAuth withTriggerParameter(String triggerParameter) {
        this.triggerParameter = triggerParameter;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretRef", this.secretRef);
        jsonWriter.writeStringField("triggerParameter", this.triggerParameter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScaleRuleAuth from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScaleRuleAuth if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScaleRuleAuth.
     */
    public static ScaleRuleAuth fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScaleRuleAuth deserializedScaleRuleAuth = new ScaleRuleAuth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secretRef".equals(fieldName)) {
                    deserializedScaleRuleAuth.secretRef = reader.getString();
                } else if ("triggerParameter".equals(fieldName)) {
                    deserializedScaleRuleAuth.triggerParameter = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScaleRuleAuth;
        });
    }
}
