// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App to be a dev service.
 */
@Fluent
public final class Service implements JsonSerializable<Service> {
    /*
     * Dev ContainerApp service type
     */
    private String type;

    /**
     * Creates an instance of Service class.
     */
    public Service() {
    }

    /**
     * Get the type property: Dev ContainerApp service type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Dev ContainerApp service type.
     * 
     * @param type the type value to set.
     * @return the Service object itself.
     */
    public Service withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model Service"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Service.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Service from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Service if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Service.
     */
    public static Service fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Service deserializedService = new Service();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedService.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedService;
        });
    }
}
