// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container resource requirements for sessions of the session pool.
 */
@Fluent
public final class SessionContainerResources implements JsonSerializable<SessionContainerResources> {
    /*
     * Required CPU in cores, e.g. 0.5
     */
    private Double cpu;

    /*
     * Required memory, e.g. "250Mb"
     */
    private String memory;

    /**
     * Creates an instance of SessionContainerResources class.
     */
    public SessionContainerResources() {
    }

    /**
     * Get the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @return the cpu value.
     */
    public Double cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @param cpu the cpu value to set.
     * @return the SessionContainerResources object itself.
     */
    public SessionContainerResources withCpu(Double cpu) {
        this.cpu = cpu;
        return this;
    }

    /**
     * Get the memory property: Required memory, e.g. "250Mb".
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Set the memory property: Required memory, e.g. "250Mb".
     * 
     * @param memory the memory value to set.
     * @return the SessionContainerResources object itself.
     */
    public SessionContainerResources withMemory(String memory) {
        this.memory = memory;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("cpu", this.cpu);
        jsonWriter.writeStringField("memory", this.memory);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SessionContainerResources from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SessionContainerResources if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SessionContainerResources.
     */
    public static SessionContainerResources fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SessionContainerResources deserializedSessionContainerResources = new SessionContainerResources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedSessionContainerResources.cpu = reader.getNullable(JsonReader::getDouble);
                } else if ("memory".equals(fieldName)) {
                    deserializedSessionContainerResources.memory = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSessionContainerResources;
        });
    }
}
