// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Session pool ingress configuration.
 */
@Fluent
public final class SessionIngress implements JsonSerializable<SessionIngress> {
    /*
     * Target port in containers for traffic from ingress
     */
    private Integer targetPort;

    /**
     * Creates an instance of SessionIngress class.
     */
    public SessionIngress() {
    }

    /**
     * Get the targetPort property: Target port in containers for traffic from ingress.
     * 
     * @return the targetPort value.
     */
    public Integer targetPort() {
        return this.targetPort;
    }

    /**
     * Set the targetPort property: Target port in containers for traffic from ingress.
     * 
     * @param targetPort the targetPort value to set.
     * @return the SessionIngress object itself.
     */
    public SessionIngress withTargetPort(Integer targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("targetPort", this.targetPort);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SessionIngress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SessionIngress if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SessionIngress.
     */
    public static SessionIngress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SessionIngress deserializedSessionIngress = new SessionIngress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetPort".equals(fieldName)) {
                    deserializedSessionIngress.targetPort = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSessionIngress;
        });
    }
}
