// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Network status for the sessions.
 */
public final class SessionNetworkStatus extends ExpandableStringEnum<SessionNetworkStatus> {
    /**
     * Static value EgressEnabled for SessionNetworkStatus.
     */
    public static final SessionNetworkStatus EGRESS_ENABLED = fromString("EgressEnabled");

    /**
     * Static value EgressDisabled for SessionNetworkStatus.
     */
    public static final SessionNetworkStatus EGRESS_DISABLED = fromString("EgressDisabled");

    /**
     * Creates a new instance of SessionNetworkStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SessionNetworkStatus() {
    }

    /**
     * Creates or finds a SessionNetworkStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SessionNetworkStatus.
     */
    public static SessionNetworkStatus fromString(String name) {
        return fromString(name, SessionNetworkStatus.class);
    }

    /**
     * Gets known SessionNetworkStatus values.
     * 
     * @return known SessionNetworkStatus values.
     */
    public static Collection<SessionNetworkStatus> values() {
        return values(SessionNetworkStatus.class);
    }
}
