// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import java.util.List;
import java.util.Map;

/**
 * An immutable client-side representation of SessionPool.
 */
public interface SessionPool {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the environmentId property: Resource ID of the session pool's environment.
     * 
     * @return the environmentId value.
     */
    String environmentId();

    /**
     * Gets the containerType property: The container type of the sessions.
     * 
     * @return the containerType value.
     */
    ContainerType containerType();

    /**
     * Gets the poolManagementType property: The pool management type of the session pool.
     * 
     * @return the poolManagementType value.
     */
    PoolManagementType poolManagementType();

    /**
     * Gets the nodeCount property: The number of nodes the session pool is using.
     * 
     * @return the nodeCount value.
     */
    Integer nodeCount();

    /**
     * Gets the scaleConfiguration property: The scale configuration of the session pool.
     * 
     * @return the scaleConfiguration value.
     */
    ScaleConfiguration scaleConfiguration();

    /**
     * Gets the secrets property: The secrets of the session pool.
     * 
     * @return the secrets value.
     */
    List<SessionPoolSecret> secrets();

    /**
     * Gets the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is dynamic.
     * 
     * @return the dynamicPoolConfiguration value.
     */
    DynamicPoolConfiguration dynamicPoolConfiguration();

    /**
     * Gets the customContainerTemplate property: The custom container configuration if the containerType is
     * CustomContainer.
     * 
     * @return the customContainerTemplate value.
     */
    CustomContainerTemplate customContainerTemplate();

    /**
     * Gets the sessionNetworkConfiguration property: The network configuration of the sessions in the session pool.
     * 
     * @return the sessionNetworkConfiguration value.
     */
    SessionNetworkConfiguration sessionNetworkConfiguration();

    /**
     * Gets the poolManagementEndpoint property: The endpoint to manage the pool.
     * 
     * @return the poolManagementEndpoint value.
     */
    String poolManagementEndpoint();

    /**
     * Gets the provisioningState property: Provisioning state of the session pool.
     * 
     * @return the provisioningState value.
     */
    SessionPoolProvisioningState provisioningState();

    /**
     * Gets the region of the resource.
     * 
     * @return the region of the resource.
     */
    Region region();

    /**
     * Gets the name of the resource region.
     * 
     * @return the name of the resource region.
     */
    String regionName();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner object.
     * 
     * @return the inner object.
     */
    SessionPoolInner innerModel();

    /**
     * The entirety of the SessionPool definition.
     */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithLocation,
        DefinitionStages.WithResourceGroup, DefinitionStages.WithCreate {
    }

    /**
     * The SessionPool definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the SessionPool definition.
         */
        interface Blank extends WithLocation {
        }

        /**
         * The stage of the SessionPool definition allowing to specify location.
         */
        interface WithLocation {
            /**
             * Specifies the region for the resource.
             * 
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(Region location);

            /**
             * Specifies the region for the resource.
             * 
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(String location);
        }

        /**
         * The stage of the SessionPool definition allowing to specify parent resource.
         */
        interface WithResourceGroup {
            /**
             * Specifies resourceGroupName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @return the next definition stage.
             */
            WithCreate withExistingResourceGroup(String resourceGroupName);
        }

        /**
         * The stage of the SessionPool definition which contains all the minimum required properties for the resource
         * to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithTags, DefinitionStages.WithEnvironmentId, DefinitionStages.WithContainerType,
            DefinitionStages.WithPoolManagementType, DefinitionStages.WithScaleConfiguration,
            DefinitionStages.WithSecrets, DefinitionStages.WithDynamicPoolConfiguration,
            DefinitionStages.WithCustomContainerTemplate, DefinitionStages.WithSessionNetworkConfiguration {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            SessionPool create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            SessionPool create(Context context);
        }

        /**
         * The stage of the SessionPool definition allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             * 
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            WithCreate withTags(Map<String, String> tags);
        }

        /**
         * The stage of the SessionPool definition allowing to specify environmentId.
         */
        interface WithEnvironmentId {
            /**
             * Specifies the environmentId property: Resource ID of the session pool's environment..
             * 
             * @param environmentId Resource ID of the session pool's environment.
             * @return the next definition stage.
             */
            WithCreate withEnvironmentId(String environmentId);
        }

        /**
         * The stage of the SessionPool definition allowing to specify containerType.
         */
        interface WithContainerType {
            /**
             * Specifies the containerType property: The container type of the sessions..
             * 
             * @param containerType The container type of the sessions.
             * @return the next definition stage.
             */
            WithCreate withContainerType(ContainerType containerType);
        }

        /**
         * The stage of the SessionPool definition allowing to specify poolManagementType.
         */
        interface WithPoolManagementType {
            /**
             * Specifies the poolManagementType property: The pool management type of the session pool..
             * 
             * @param poolManagementType The pool management type of the session pool.
             * @return the next definition stage.
             */
            WithCreate withPoolManagementType(PoolManagementType poolManagementType);
        }

        /**
         * The stage of the SessionPool definition allowing to specify scaleConfiguration.
         */
        interface WithScaleConfiguration {
            /**
             * Specifies the scaleConfiguration property: The scale configuration of the session pool..
             * 
             * @param scaleConfiguration The scale configuration of the session pool.
             * @return the next definition stage.
             */
            WithCreate withScaleConfiguration(ScaleConfiguration scaleConfiguration);
        }

        /**
         * The stage of the SessionPool definition allowing to specify secrets.
         */
        interface WithSecrets {
            /**
             * Specifies the secrets property: The secrets of the session pool..
             * 
             * @param secrets The secrets of the session pool.
             * @return the next definition stage.
             */
            WithCreate withSecrets(List<SessionPoolSecret> secrets);
        }

        /**
         * The stage of the SessionPool definition allowing to specify dynamicPoolConfiguration.
         */
        interface WithDynamicPoolConfiguration {
            /**
             * Specifies the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is
             * dynamic..
             * 
             * @param dynamicPoolConfiguration The pool configuration if the poolManagementType is dynamic.
             * @return the next definition stage.
             */
            WithCreate withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration);
        }

        /**
         * The stage of the SessionPool definition allowing to specify customContainerTemplate.
         */
        interface WithCustomContainerTemplate {
            /**
             * Specifies the customContainerTemplate property: The custom container configuration if the containerType
             * is CustomContainer..
             * 
             * @param customContainerTemplate The custom container configuration if the containerType is
             * CustomContainer.
             * @return the next definition stage.
             */
            WithCreate withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate);
        }

        /**
         * The stage of the SessionPool definition allowing to specify sessionNetworkConfiguration.
         */
        interface WithSessionNetworkConfiguration {
            /**
             * Specifies the sessionNetworkConfiguration property: The network configuration of the sessions in the
             * session pool..
             * 
             * @param sessionNetworkConfiguration The network configuration of the sessions in the session pool.
             * @return the next definition stage.
             */
            WithCreate withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration);
        }
    }

    /**
     * Begins update for the SessionPool resource.
     * 
     * @return the stage of resource update.
     */
    SessionPool.Update update();

    /**
     * The template for SessionPool update.
     */
    interface Update extends UpdateStages.WithScaleConfiguration, UpdateStages.WithSecrets,
        UpdateStages.WithDynamicPoolConfiguration, UpdateStages.WithCustomContainerTemplate,
        UpdateStages.WithSessionNetworkConfiguration {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        SessionPool apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        SessionPool apply(Context context);
    }

    /**
     * The SessionPool update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the SessionPool update allowing to specify scaleConfiguration.
         */
        interface WithScaleConfiguration {
            /**
             * Specifies the scaleConfiguration property: The scale configuration of the session pool..
             * 
             * @param scaleConfiguration The scale configuration of the session pool.
             * @return the next definition stage.
             */
            Update withScaleConfiguration(ScaleConfiguration scaleConfiguration);
        }

        /**
         * The stage of the SessionPool update allowing to specify secrets.
         */
        interface WithSecrets {
            /**
             * Specifies the secrets property: The secrets of the session pool..
             * 
             * @param secrets The secrets of the session pool.
             * @return the next definition stage.
             */
            Update withSecrets(List<SessionPoolSecret> secrets);
        }

        /**
         * The stage of the SessionPool update allowing to specify dynamicPoolConfiguration.
         */
        interface WithDynamicPoolConfiguration {
            /**
             * Specifies the dynamicPoolConfiguration property: The pool configuration if the poolManagementType is
             * dynamic..
             * 
             * @param dynamicPoolConfiguration The pool configuration if the poolManagementType is dynamic.
             * @return the next definition stage.
             */
            Update withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration);
        }

        /**
         * The stage of the SessionPool update allowing to specify customContainerTemplate.
         */
        interface WithCustomContainerTemplate {
            /**
             * Specifies the customContainerTemplate property: The custom container configuration if the containerType
             * is CustomContainer..
             * 
             * @param customContainerTemplate The custom container configuration if the containerType is
             * CustomContainer.
             * @return the next definition stage.
             */
            Update withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate);
        }

        /**
         * The stage of the SessionPool update allowing to specify sessionNetworkConfiguration.
         */
        interface WithSessionNetworkConfiguration {
            /**
             * Specifies the sessionNetworkConfiguration property: The network configuration of the sessions in the
             * session pool..
             * 
             * @param sessionNetworkConfiguration The network configuration of the sessions in the session pool.
             * @return the next definition stage.
             */
            Update withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    SessionPool refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    SessionPool refresh(Context context);
}
