// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the session pool.
 */
public final class SessionPoolProvisioningState extends ExpandableStringEnum<SessionPoolProvisioningState> {
    /**
     * Static value InProgress for SessionPoolProvisioningState.
     */
    public static final SessionPoolProvisioningState IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Succeeded for SessionPoolProvisioningState.
     */
    public static final SessionPoolProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for SessionPoolProvisioningState.
     */
    public static final SessionPoolProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Canceled for SessionPoolProvisioningState.
     */
    public static final SessionPoolProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Deleting for SessionPoolProvisioningState.
     */
    public static final SessionPoolProvisioningState DELETING = fromString("Deleting");

    /**
     * Creates a new instance of SessionPoolProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SessionPoolProvisioningState() {
    }

    /**
     * Creates or finds a SessionPoolProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SessionPoolProvisioningState.
     */
    public static SessionPoolProvisioningState fromString(String name) {
        return fromString(name, SessionPoolProvisioningState.class);
    }

    /**
     * Gets known SessionPoolProvisioningState values.
     * 
     * @return known SessionPoolProvisioningState values.
     */
    public static Collection<SessionPoolProvisioningState> values() {
        return values(SessionPoolProvisioningState.class);
    }
}
